/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.security.authorization;

import com.rapidclipse.framework.security.authorization.AuthorizationManager;
import com.rapidclipse.framework.security.authorization.Resource;
import com.rapidclipse.framework.security.authorization.Subject;
import com.rapidclipse.framework.server.navigation.Navigation;
import com.rapidclipse.framework.server.security.authentication.Authentication;
import com.rapidclipse.framework.server.security.authorization.PermissionDeniedView;
import com.rapidclipse.framework.server.security.authorization.RouteResourcesProvider;
import com.rapidclipse.framework.server.security.authorization.SubjectEvaluatingComponentExtension;
import com.rapidclipse.framework.server.security.authorization.SubjectEvaluationStrategy;
import com.rapidclipse.framework.server.security.authorization.UnauthorizedNavigationRequestHandler;
import com.rapidclipse.framework.server.ui.UIUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.BeforeEvent;
import java.util.Collection;
import java.util.Objects;

public final class Authorization {
    private static UnauthorizedNavigationRequestHandler unauthorizedNavigationRequestHandler = UnauthorizedNavigationRequestHandler.Default();
    private static RouteResourcesProvider routeResourcesProvider = RouteResourcesProvider.Default();

    public static void setAuthorizationManager(AuthorizationManager authorizationManager) {
        UI.getCurrent().getSession().setAttribute(AuthorizationManager.class, (Object)authorizationManager);
    }

    public static AuthorizationManager getAuthorizationManager() {
        return (AuthorizationManager)UI.getCurrent().getSession().getAttribute(AuthorizationManager.class);
    }

    public static Resource getResource(String name) throws IllegalStateException, IllegalArgumentException {
        AuthorizationManager authorizationManager = Authorization.getAuthorizationManager();
        if (authorizationManager == null) {
            throw new IllegalStateException("No authorization manager has been initialized");
        }
        Resource resource = authorizationManager.resource(name);
        if (resource == null) {
            throw new IllegalArgumentException("Resource not found: " + name);
        }
        return resource;
    }

    public static Resource resource(String name) {
        try {
            return Authorization.getResource(name);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return Resource.New((String)name);
        }
    }

    public static void setSubjectEvaluatingComponentExtension(Component component, SubjectEvaluatingComponentExtension extension) {
        ComponentUtil.setData((Component)component, SubjectEvaluatingComponentExtension.class, (Object)extension);
    }

    public static SubjectEvaluatingComponentExtension getSubjectEvaluatingComponentExtension(Component component) {
        return (SubjectEvaluatingComponentExtension)ComponentUtil.getData((Component)component, SubjectEvaluatingComponentExtension.class);
    }

    public static void copyResources(Class<?> routedType, Component component, SubjectEvaluationStrategy strategy) {
        Collection<Resource> resources = Authorization.getRouteResourcesProvider().getResourcesFor(routedType);
        if (!resources.isEmpty()) {
            SubjectEvaluatingComponentExtension.Builder builder = SubjectEvaluatingComponentExtension.Builder();
            resources.forEach(r -> builder.add((Resource)r, strategy));
            Authorization.setSubjectEvaluatingComponentExtension(component, builder.build());
        }
    }

    public static void evaluateComponents(Component root) {
        if (Authentication.isUserLoggedIn()) {
            Authorization.evaluateComponents(root, Authentication.getUser());
        }
    }

    public static void evaluateComponents(Component root, Subject subject) {
        UIUtils.lookupComponentTree((Component)root, component -> {
            Authorization.evaluateComponent(component, subject);
            return null;
        });
    }

    public static void evaluateComponent(Component component, Subject subject) {
        SubjectEvaluatingComponentExtension extension = Authorization.getSubjectEvaluatingComponentExtension(component);
        if (extension != null) {
            extension.evaluateSubject(component, subject);
        }
    }

    public static void navigateToPermissionDeniedView() {
        Navigation.navigateTo(PermissionDeniedView.class);
    }

    public static void rerouteToPermissionDeniedView(BeforeEvent event) {
        Navigation.rerouteTo((BeforeEvent)event, PermissionDeniedView.class);
    }

    public static void setUnauthorizedNavigationRequestHandler(UnauthorizedNavigationRequestHandler unauthorizedNavigationRequestHandler) {
        Authorization.unauthorizedNavigationRequestHandler = Objects.requireNonNull(unauthorizedNavigationRequestHandler);
    }

    public static UnauthorizedNavigationRequestHandler getUnauthorizedNavigationRequestHandler() {
        return unauthorizedNavigationRequestHandler;
    }

    public static void setRouteResourcesProvider(RouteResourcesProvider routeResourcesProvider) {
        Authorization.routeResourcesProvider = Objects.requireNonNull(routeResourcesProvider);
    }

    public static RouteResourcesProvider getRouteResourcesProvider() {
        return routeResourcesProvider;
    }

    private Authorization() {
        throw new Error();
    }
}

