/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.security.authorization;

import com.rapidclipse.framework.security.authorization.Resource;
import com.rapidclipse.framework.server.security.authorization.Authorization;
import com.rapidclipse.framework.server.security.authorization.Resources;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

@FunctionalInterface
public interface RouteResourcesProvider {
    public Collection<Resource> getResourcesFor(Class<?> var1);

    public static RouteResourcesProvider Default() {
        return new AnnotationBased();
    }

    public static class AnnotationBased
    implements RouteResourcesProvider {
        @Override
        public Collection<Resource> getResourcesFor(Class<?> target) {
            String[] names;
            Resources resources = target.getAnnotation(Resources.class);
            if (resources != null && (names = resources.value()) != null && names.length > 0) {
                return Arrays.stream(names).map(Authorization::resource).collect(Collectors.toList());
            }
            return null;
        }
    }
}

