/*
 * Decompiled with CFR 0.152.
 */
package com.rapidclipse.framework.server.security.authorization;

import com.rapidclipse.framework.security.authorization.Resource;
import com.rapidclipse.framework.security.authorization.Subject;
import com.rapidclipse.framework.server.security.authorization.SubjectEvaluationStrategy;
import com.vaadin.flow.component.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@FunctionalInterface
public interface SubjectEvaluatingComponentExtension {
    public static Builder Builder() {
        return Builder.New();
    }

    public void evaluateSubject(Component var1, Subject var2);

    public static SubjectEvaluatingComponentExtension New(Resource resource, SubjectEvaluationStrategy strategy) {
        return Builder.New().add(resource, strategy).build();
    }

    public static SubjectEvaluatingComponentExtension New(Map<Resource, SubjectEvaluationStrategy> resourceStrategies) {
        return new Default(resourceStrategies);
    }

    public static class Default
    implements SubjectEvaluatingComponentExtension {
        protected final Map<Resource, SubjectEvaluationStrategy> resourceStrategies;

        protected Default(Map<Resource, SubjectEvaluationStrategy> resourceStrategies) {
            Objects.requireNonNull(resourceStrategies);
            this.resourceStrategies = resourceStrategies;
        }

        @Override
        public void evaluateSubject(Component component, Subject subject) {
            this.resourceStrategies.entrySet().forEach(entry -> {
                Resource resource = (Resource)entry.getKey();
                SubjectEvaluationStrategy strategy = (SubjectEvaluationStrategy)entry.getValue();
                boolean hasPermission = subject.hasPermission(resource);
                strategy.subjectEvaluated(component, hasPermission);
            });
        }
    }

    public static interface Builder {
        public Builder add(Resource var1, SubjectEvaluationStrategy var2);

        public SubjectEvaluatingComponentExtension build();

        public static Builder New() {
            return new Default();
        }

        public static class Default
        implements Builder {
            protected final Map<Resource, SubjectEvaluationStrategy> resourceStrategies = new LinkedHashMap<Resource, SubjectEvaluationStrategy>();

            protected Default() {
            }

            @Override
            public Builder add(Resource resource, SubjectEvaluationStrategy strategy) {
                Objects.requireNonNull(resource);
                Objects.requireNonNull(strategy);
                this.resourceStrategies.put(resource, strategy);
                return this;
            }

            @Override
            public SubjectEvaluatingComponentExtension build() {
                return SubjectEvaluatingComponentExtension.New(this.resourceStrategies);
            }
        }
    }
}

