/*
 * Decompiled with CFR 0.152.
 */
package com.researchspace.figshare.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class FigshareUtils {
    final String baseURL = "https://api.figshare.com";
    final String version = "/v2";

    String createPath(String endpoint) {
        return "https://api.figshare.com/v2" + endpoint;
    }

    HttpEntity<String> createHttpEntity(String body, String personalToken) {
        if (!StringUtils.isEmpty((String)personalToken)) {
            HttpHeaders headers = new HttpHeaders();
            headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
            this.addAPIKeyToHeader(headers, personalToken);
            return new HttpEntity((Object)body, (MultiValueMap)headers);
        }
        return new HttpEntity((Object)body);
    }

    private void addAPIKeyToHeader(HttpHeaders headers, String personalToken) {
        headers.add("Authorization", " token " + personalToken);
    }

    <T> T readFromString(ResponseEntity<String> resp, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        Object obj = null;
        try {
            obj = mapper.readValue((String)resp.getBody(), clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)obj;
    }
}

