/*
 * Decompiled with CFR 0.152.
 */
package com.researchspace.figshare.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class LoggingResponseErrorHandler
extends DefaultResponseErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(LoggingResponseErrorHandler.class);

    public void handleError(ClientHttpResponse response) throws IOException {
        log.error("Response error: {} {}", (Object)response.getStatusCode(), (Object)response.getStatusText());
        StringBuffer buffer = new StringBuffer();
        try (InputStream bodyStream = response.getBody();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(bodyStream));
            while (reader.ready()) {
                buffer.append(reader.readLine());
            }
        }
        log.error(buffer.toString());
        if (response.getStatusCode().equals((Object)HttpStatus.FORBIDDEN)) {
            super.handleError(response);
        }
    }
}

