/*
 * Decompiled with CFR 0.152.
 */
package com.researchspace.figshare.model;

import com.researchspace.figshare.model.Author;
import com.researchspace.figshare.model.Category;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ArticlePresenter {
    String title;
    String description;
    private List<Author> authors;
    private List<Category> categories;
    private List<String> tags;
    private List<String> references;

    public static ArticlePresenterBuilder builder() {
        return new ArticlePresenterBuilder();
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Author> getAuthors() {
        return this.authors;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<String> getReferences() {
        return this.references;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setReferences(List<String> references) {
        this.references = references;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArticlePresenter)) {
            return false;
        }
        ArticlePresenter other = (ArticlePresenter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Author> this$authors = this.getAuthors();
        List<Author> other$authors = other.getAuthors();
        if (this$authors == null ? other$authors != null : !((Object)this$authors).equals(other$authors)) {
            return false;
        }
        List<Category> this$categories = this.getCategories();
        List<Category> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<String> this$references = this.getReferences();
        List<String> other$references = other.getReferences();
        return !(this$references == null ? other$references != null : !((Object)this$references).equals(other$references));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArticlePresenter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Author> $authors = this.getAuthors();
        result = result * 59 + ($authors == null ? 43 : ((Object)$authors).hashCode());
        List<Category> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<String> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        return result;
    }

    public String toString() {
        return "ArticlePresenter(title=" + this.getTitle() + ", description=" + this.getDescription() + ", authors=" + this.getAuthors() + ", categories=" + this.getCategories() + ", tags=" + this.getTags() + ", references=" + this.getReferences() + ")";
    }

    @ConstructorProperties(value={"title", "description", "authors", "categories", "tags", "references"})
    public ArticlePresenter(String title, String description, List<Author> authors, List<Category> categories, List<String> tags, List<String> references) {
        this.title = title;
        this.description = description;
        this.authors = authors;
        this.categories = categories;
        this.tags = tags;
        this.references = references;
    }

    public ArticlePresenter() {
    }

    public static class ArticlePresenterBuilder {
        private String title;
        private String description;
        private ArrayList<Author> authors;
        private List<Category> categories;
        private List<String> tags;
        private List<String> references;

        ArticlePresenterBuilder() {
        }

        public ArticlePresenterBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ArticlePresenterBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ArticlePresenterBuilder author(Author author) {
            if (this.authors == null) {
                this.authors = new ArrayList();
            }
            this.authors.add(author);
            return this;
        }

        public ArticlePresenterBuilder authors(Collection<? extends Author> authors) {
            if (this.authors == null) {
                this.authors = new ArrayList();
            }
            this.authors.addAll(authors);
            return this;
        }

        public ArticlePresenterBuilder clearAuthors() {
            if (this.authors != null) {
                this.authors.clear();
            }
            return this;
        }

        public ArticlePresenterBuilder categories(List<Category> categories) {
            this.categories = categories;
            return this;
        }

        public ArticlePresenterBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public ArticlePresenterBuilder references(List<String> references) {
            this.references = references;
            return this;
        }

        public ArticlePresenter build() {
            List<Author> authors;
            switch (this.authors == null ? 0 : this.authors.size()) {
                case 0: {
                    authors = Collections.emptyList();
                    break;
                }
                case 1: {
                    authors = Collections.singletonList(this.authors.get(0));
                    break;
                }
                default: {
                    authors = Collections.unmodifiableList(new ArrayList<Author>(this.authors));
                }
            }
            return new ArticlePresenter(this.title, this.description, authors, this.categories, this.tags, this.references);
        }

        public String toString() {
            return "ArticlePresenter.ArticlePresenterBuilder(title=" + this.title + ", description=" + this.description + ", authors=" + this.authors + ", categories=" + this.categories + ", tags=" + this.tags + ", references=" + this.references + ")";
        }
    }
}

