/*
 * Decompiled with CFR 0.152.
 */
package com.researchspace.figshare.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.researchspace.figshare.api.Figshare;
import com.researchspace.figshare.api.FileOperations;
import com.researchspace.figshare.impl.FigshareUtils;
import com.researchspace.figshare.impl.FileOperationsImpl;
import com.researchspace.figshare.impl.LoggingResponseErrorHandler;
import com.researchspace.figshare.model.Account;
import com.researchspace.figshare.model.ArticlePost;
import com.researchspace.figshare.model.ArticlePresenter;
import com.researchspace.figshare.model.Category;
import com.researchspace.figshare.model.FigshareError;
import com.researchspace.figshare.model.FigshareResponse;
import com.researchspace.figshare.model.FilePresenter;
import com.researchspace.figshare.model.License;
import com.researchspace.figshare.model.Location;
import com.researchspace.figshare.model.PrivateArticle;
import com.researchspace.figshare.model.PrivateArticleLink;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.social.oauth2.AbstractOAuth2ApiBinding;
import org.springframework.social.oauth2.TokenStrategy;
import org.springframework.social.support.ClientHttpRequestFactorySelector;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public final class FigshareTemplate
extends AbstractOAuth2ApiBinding
implements Figshare {
    Logger log = LoggerFactory.getLogger(FigshareTemplate.class);
    private String personalToken;
    private FileOperations fileOps;
    private FigshareUtils utils;

    public void setPersonalToken(String personalToken) {
        this.personalToken = personalToken;
    }

    public FigshareTemplate() {
    }

    public FigshareTemplate(String accessToken) {
        super(accessToken, TokenStrategy.ACCESS_TOKEN_PARAMETER);
        this.init();
    }

    protected void postConstructionConfiguration() {
        this.init();
    }

    private void init() {
        this.fileOps = new FileOperationsImpl(this.getRestTemplate(), this.personalToken);
        this.utils = new FigshareUtils();
    }

    public void setFileOps(FileOperations fileOps) {
        this.fileOps = fileOps;
    }

    @Override
    public boolean test() {
        return this.account().getEmail() != null;
    }

    @Override
    public Location createArticle(ArticlePost article) {
        String url = this.utils.createPath("/account/articles");
        String json = this.marshalObject(article);
        HttpEntity<String> entity = this.utils.createHttpEntity(json, this.personalToken);
        ResponseEntity resp = this.getRestTemplate().postForEntity(url, entity, String.class, new Object[0]);
        this.log.debug(resp.toString());
        Location location = this.utils.readFromString((ResponseEntity<String>)resp, Location.class);
        return location;
    }

    @Override
    public Location createFile(Long articleId, File file) {
        String url = this.utils.createPath("/account/articles/{articleId}/files");
        ObjectNode node = this.createFileJson(file);
        HttpEntity<String> entity = this.utils.createHttpEntity(this.marshalObject(node), this.personalToken);
        ResponseEntity resp = this.getRestTemplate().postForEntity(url, entity, String.class, new Object[]{articleId});
        this.log.debug(resp.toString());
        Location location = this.utils.readFromString((ResponseEntity<String>)resp, Location.class);
        return location;
    }

    private ObjectNode createFileJson(File file) {
        JsonNodeFactory nodeFactory = new JsonNodeFactory(false);
        ObjectNode node = nodeFactory.objectNode();
        node.put("size", file.length());
        node.put("name", file.getName());
        return node;
    }

    @Override
    public Account account() {
        String url = this.utils.createPath("/account");
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.GET, this.createEmptyEntity(), Account.class, new Object[0]);
        this.log.debug(resp.toString());
        return (Account)resp.getBody();
    }

    @Override
    public boolean deleteArticle(Long id) {
        String url = this.utils.createPath("/account/articles/{id}");
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.DELETE, this.createEmptyEntity(), String.class, new Object[]{id});
        this.log.debug(resp.toString());
        return HttpStatus.NO_CONTENT.equals((Object)resp.getStatusCode());
    }

    @Override
    public boolean deleteFile(Long articleId, Long fileId) {
        String url = this.utils.createPath("/account/articles/{id}/files/{file_id}");
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.DELETE, this.createEmptyEntity(), String.class, new Object[]{articleId, fileId});
        this.log.debug(resp.toString());
        return HttpStatus.NO_CONTENT.equals((Object)resp.getStatusCode());
    }

    private String marshalObject(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    @Override
    public FileOperations getFileOperations() {
        return this.fileOps;
    }

    @Override
    public Location uploadFile(Long articleId, File toUpload) {
        Location newFile = this.createFile(articleId, toUpload);
        FilePresenter status = this.fileOps.getFileUploadInfo(articleId, newFile.getId());
        try {
            this.fileOps.uploadParts(status, toUpload);
        }
        catch (IOException e) {
            throw new RestClientException(String.format("Problem uploading file %s - %s", toUpload.getName(), e.getMessage()), (Throwable)e);
        }
        this.fileOps.markFileUploadCompleted(articleId, newFile.getId());
        return newFile;
    }

    @Override
    public Location dropFilesAndReplace(Long articleId, File toUpload) {
        List<FilePresenter> filesToDelete = this.getFiles(articleId);
        filesToDelete.stream().forEach(file -> this.deleteFile(articleId, file.getId()));
        return this.uploadFile(articleId, toUpload);
    }

    @Override
    public List<FilePresenter> getFiles(Long articleId) {
        String url = this.utils.createPath("/account/articles/{id}/files");
        ParameterizedTypeReference<List<FilePresenter>> pt = new ParameterizedTypeReference<List<FilePresenter>>(){};
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.GET, this.createEmptyEntity(), (ParameterizedTypeReference)pt, new Object[]{articleId});
        return (List)resp.getBody();
    }

    @Override
    public ArticlePresenter getArticle(Long articleId) {
        String url = this.utils.createPath("/account/articles/{id}");
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.GET, this.createEmptyEntity(), ArticlePresenter.class, new Object[]{articleId});
        this.log.debug(((ArticlePresenter)resp.getBody()).toString());
        return (ArticlePresenter)resp.getBody();
    }

    protected void configureRestTemplate(RestTemplate restTemplate) {
        restTemplate.setErrorHandler((ResponseErrorHandler)new LoggingResponseErrorHandler());
        restTemplate.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory(ClientHttpRequestFactorySelector.getRequestFactory()));
    }

    protected ByteArrayHttpMessageConverter getByteArrayMessageConverter() {
        ByteArrayHttpMessageConverter converter = new ByteArrayHttpMessageConverter();
        converter.setSupportedMediaTypes(Arrays.asList(MediaType.ALL));
        return converter;
    }

    @Override
    public List<Category> getCategories() {
        String url = this.utils.createPath("/categories");
        ParameterizedTypeReference<List<Category>> pt = new ParameterizedTypeReference<List<Category>>(){};
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.GET, this.createEmptyEntity(), (ParameterizedTypeReference)pt, new Object[0]);
        List cats = (List)resp.getBody();
        return cats;
    }

    @Override
    public List<License> getLicenses() {
        String url = this.utils.createPath("/licenses");
        ParameterizedTypeReference<List<License>> pt = new ParameterizedTypeReference<List<License>>(){};
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.GET, this.createEmptyEntity(), (ParameterizedTypeReference)pt, new Object[0]);
        List licenses = (List)resp.getBody();
        licenses.stream().filter(l -> l.getUrl().toString().equals("https://creativecommons.org/licenses/by/4.0/")).findFirst().ifPresent(l -> l.setDefaultLicense(true));
        return licenses;
    }

    @Override
    public FigshareResponse<Location> publishArticle(Long id) {
        String url = this.utils.createPath("/account/articles/{id}/publish");
        ResponseEntity resp = this.getRestTemplate().postForEntity(url, this.createEmptyEntity(), String.class, new Object[]{id});
        if (resp.getStatusCode().is2xxSuccessful()) {
            Location location = this.utils.readFromString((ResponseEntity<String>)resp, Location.class);
            return new FigshareResponse<Location>(location, null);
        }
        FigshareError error = this.utils.readFromString((ResponseEntity<String>)resp, FigshareError.class);
        error.setStatus(resp.getStatusCode());
        return new FigshareResponse<Object>(null, error);
    }

    @Override
    public PrivateArticleLink createPrivateArticleLink(Long articleId) {
        String url = this.utils.createPath("/account/articles/{id}/private_links");
        ResponseEntity resp = this.getRestTemplate().postForEntity(url, this.createEmptyEntity(), String.class, new Object[]{articleId});
        PrivateArticleLink location = this.utils.readFromString((ResponseEntity<String>)resp, PrivateArticleLink.class);
        this.log.debug(((String)resp.getBody()).toString());
        return location;
    }

    @Override
    public List<PrivateArticle> getPrivateArticleLinks(Long articleId) {
        String url = this.utils.createPath("/account/articles/{id}/private_links");
        ParameterizedTypeReference<List<PrivateArticle>> pt = new ParameterizedTypeReference<List<PrivateArticle>>(){};
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.GET, this.createEmptyEntity(), (ParameterizedTypeReference)pt, new Object[]{articleId});
        this.log.debug(((List)resp.getBody()).toString());
        return (List)resp.getBody();
    }

    @Override
    public void deletePrivateArticleLink(Long articleId, String uniqueLinkKey) {
        String url = this.utils.createPath("/account/articles/{id}/private_links/{private_link_id}");
        ResponseEntity resp = this.getRestTemplate().exchange(url, HttpMethod.DELETE, this.createEmptyEntity(), String.class, new Object[]{articleId, uniqueLinkKey});
        this.log.debug(resp.getStatusCode().name());
    }

    private HttpEntity<String> createEmptyEntity() {
        HttpEntity<String> entity = this.utils.createHttpEntity("", this.personalToken);
        return entity;
    }
}

