/*
 * Decompiled with CFR 0.152.
 */
package com.researchspace.figshare.impl;

import com.researchspace.figshare.api.FileOperations;
import com.researchspace.figshare.impl.FigshareUtils;
import com.researchspace.figshare.impl.FileSplitter;
import com.researchspace.figshare.model.FilePart;
import com.researchspace.figshare.model.FilePresenter;
import com.researchspace.figshare.model.FileUploadProcess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class FileOperationsImpl
implements FileOperations {
    private static final Logger log = LoggerFactory.getLogger(FileOperationsImpl.class);
    private RestTemplate template;
    private String accessToken;
    private FileSplitter splitter;
    private FigshareUtils utils;

    public FileOperationsImpl(RestTemplate restTemplate, String accessToken) {
        this.template = restTemplate;
        this.accessToken = accessToken;
        this.splitter = new FileSplitter();
        this.utils = new FigshareUtils();
    }

    @Override
    public boolean markFileUploadCompleted(Long articleId, Long fileId) {
        String url = this.utils.createPath("/account/articles/{articleId}/files/{fileId}");
        HttpEntity<String> entity = this.utils.createHttpEntity("", this.accessToken);
        ResponseEntity resp = this.template.exchange(url.toString(), HttpMethod.POST, entity, String.class, new Object[]{articleId, fileId});
        log.debug(resp.toString());
        return HttpStatus.ACCEPTED.equals((Object)resp.getStatusCode());
    }

    @Override
    public FilePresenter getFileUploadInfo(Long articleId, Long fileId) {
        String url = this.utils.createPath("/account/articles/{articleId}/files/{fileId}");
        HttpEntity<String> entity = this.utils.createHttpEntity("", this.accessToken);
        ResponseEntity resp = this.template.exchange(url, HttpMethod.GET, entity, FilePresenter.class, new Object[]{articleId, fileId});
        log.debug(resp.toString());
        return (FilePresenter)resp.getBody();
    }

    @Override
    public FileUploadProcess uploadParts(FilePresenter uploadStatus, File dataFile) throws IOException {
        URL url = uploadStatus.getUploadURL();
        FileUploadProcess process = (FileUploadProcess)this.template.getForObject(url.toString(), FileUploadProcess.class, new Object[0]);
        process.getParts().parallelStream().forEach(part -> {
            File splitted = null;
            try {
                splitted = this.splitter.extract(dataFile, (FilePart)part);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String uploadURL = url.toString() + "/" + part.getPartNo();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            try {
                byte[] bytes = IOUtils.toByteArray((InputStream)new FileSystemResource(splitted.getAbsolutePath()).getInputStream());
                HttpEntity entity = new HttpEntity((Object)bytes, (MultiValueMap)headers);
                ResponseEntity resp = this.template.exchange(uploadURL, HttpMethod.PUT, entity, String.class, new Object[]{uploadStatus.getUploadToken(), part.getPartNo()});
                log.debug("Uploaded part {}: {}", (Object)part.getPartNo(), resp.getBody());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        log.debug(process.toString());
        return process;
    }
}

