/*
 * Decompiled with CFR 0.152.
 */
package com.researchspace.figshare.impl;

import com.researchspace.figshare.model.FilePart;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSplitter {
    private static final Logger log = LoggerFactory.getLogger(FileSplitter.class);

    File extract(File orig, FilePart part) throws FileNotFoundException, IOException {
        File tmpDir = FileUtils.getTempDirectory();
        String randomName = RandomStringUtils.randomAlphabetic((int)10);
        File workFolder = new File(tmpDir, randomName);
        FileUtils.forceMkdir((File)workFolder);
        FileUtils.copyFileToDirectory((File)orig, (File)workFolder);
        File copy = workFolder.listFiles()[0];
        int start = part.getStartOffset().intValue();
        int end = part.getEndOffset().intValue() + 1;
        int partNo = part.getPartNo();
        int sizeOfFiles = end - start;
        byte[] buffer = new byte[sizeOfFiles];
        File newFile = new File(workFolder, this.createPartFileName(orig, partNo));
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(copy));){
            bis.skip(start);
            int tmp = 0;
            tmp = bis.read(buffer);
            try (FileOutputStream out = new FileOutputStream(newFile);){
                out.write(buffer, 0, tmp);
            }
        }
        log.debug("Split file is {} of length {}", (Object)newFile.getName(), (Object)newFile.length());
        return newFile;
    }

    private String createPartFileName(File orig, int partNo) {
        return FilenameUtils.getBaseName((String)orig.getName()) + "-" + String.format("%03d", partNo) + "." + FilenameUtils.getExtension((String)orig.getName());
    }
}

