/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.emails;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.provider.AuthenticationProvider;
import com.resend.core.service.BaseService;
import com.resend.services.emails.model.Email;
import com.resend.services.emails.model.SendEmailRequest;
import com.resend.services.emails.model.SendEmailResponse;
import okhttp3.MediaType;

public class ResendEmails
extends BaseService {
    public ResendEmails() {
    }

    public ResendEmails(AuthenticationProvider authenticationProvider) {
        super(authenticationProvider);
    }

    public SendEmailResponse sendEmail(SendEmailRequest sendEmailRequest) throws ResendException {
        String payload = this.resendMapper.writeValue(sendEmailRequest);
        AbstractHttpResponse response = this.httpClient.perform("/emails", super.getAuthenticationProvider().token(), HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to send email: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        SendEmailResponse sendEmailResponse = this.resendMapper.readValue(responseBody, SendEmailResponse.class);
        return sendEmailResponse;
    }

    public Email retrieveEmail(String emailId) throws ResendException {
        try {
            AbstractHttpResponse response = this.httpClient.perform("/emails/" + emailId, super.getAuthenticationProvider().token(), HttpMethod.GET, null, MediaType.get((String)"application/json"));
            if (!response.isSuccessful()) {
                throw new RuntimeException("Failed to retrieve email: " + response.getCode() + " " + (String)response.getBody());
            }
            String responseBody = (String)response.getBody();
            Email email = this.resendMapper.readValue(responseBody, Email.class);
            return email;
        }
        catch (Exception e) {
            throw new RuntimeException("Error retrieving email: " + e.getMessage(), e);
        }
    }
}

