package com.resend.core.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * The `PropertiesReader` class provides methods to read properties from a file named "gradle.properties."
 */
public class PropertiesReader {
    private final Properties properties;

    /**
     * Constructs a new `PropertiesReader` object, initializing the internal `Properties` instance.
     */
    public PropertiesReader() {
        this.properties = new Properties();
    }

    /**
     * Retrieves the value of a property by its name from the "gradle.properties" file.
     *
     * @param propertyName The name of the property to retrieve.
     * @return The value of the specified property.
     * @throws RuntimeException if an I/O error occurs or if the property file is not found.
     */
    public String retrieveProperty(String propertyName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream("gradle.properties");
            properties.load(fis);
            fis.close();
        } catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return properties.getProperty(propertyName);
    }
}