/*
 * Decompiled with CFR 0.152.
 */
package com.resend.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;

public class DateTimeDeserializer
extends JsonDeserializer<OffsetDateTime> {
    public OffsetDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String date = parser.getText();
        try {
            return OffsetDateTime.parse(date);
        }
        catch (DateTimeParseException e) {
            throw new IOException("Error parsing OffsetDateTime: " + date, e);
        }
    }
}

