/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.contacts;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.contacts.model.ContactRequestOptions;
import com.resend.services.contacts.model.CreateContactRequestOptions;
import com.resend.services.contacts.model.CreateContactResponseSuccess;
import com.resend.services.contacts.model.GetContactResponseSuccess;
import com.resend.services.contacts.model.ListContactsResponseSuccess;
import com.resend.services.contacts.model.RemoveContactResponseSuccess;
import okhttp3.MediaType;

public class Contacts
extends BaseService {
    public Contacts(String apiKey) {
        super(apiKey);
    }

    public CreateContactResponseSuccess create(CreateContactRequestOptions createContactRequestOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createContactRequestOptions);
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + createContactRequestOptions.getAudienceId() + "/contacts", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to create contact: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CreateContactResponseSuccess.class);
    }

    public ListContactsResponseSuccess list(String audienceId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + audienceId + "/contacts", this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to retrieve contacts: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, ListContactsResponseSuccess.class);
    }

    public GetContactResponseSuccess get(ContactRequestOptions params) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + params.getAudienceId() + "/contacts/" + params.getId(), this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to retrieve contact: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, GetContactResponseSuccess.class);
    }

    public RemoveContactResponseSuccess remove(ContactRequestOptions params) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/audiences/" + params.getAudienceId() + "/contacts/" + params.getId(), this.apiKey, HttpMethod.DELETE, "", null);
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to delete contact: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, RemoveContactResponseSuccess.class);
    }
}

