/*
 * Decompiled with CFR 0.152.
 */
package com.resend.core.net.impl;

import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.net.IHttpClient;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpClient
implements IHttpClient<Response> {
    public static final String BASE_API = "https://api.resend.com";
    private static final String VERSION_NAME = "3.0.2";
    public static final String USER_AGENT = "resend-java/3.0.2";
    private final OkHttpClient httpClient = new OkHttpClient();

    @Override
    public AbstractHttpResponse perform(String path, String apiKey, HttpMethod method, String payload, MediaType mediaType) {
        RequestBody requestBody = null;
        if (payload != null) {
            requestBody = RequestBody.create((String)payload, (MediaType)mediaType);
        }
        Request request = new Request.Builder().url(BASE_API + path).addHeader("Accept", "application/json").addHeader("User-Agent", USER_AGENT).addHeader("Authorization", "Bearer " + apiKey).method(method.name(), requestBody).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            return new AbstractHttpResponse<String>(response.code(), response.body().string(), response.isSuccessful());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

