/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.apikeys;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.apikeys.model.CreateApiKeyOptions;
import com.resend.services.apikeys.model.CreateApiKeyResponse;
import com.resend.services.apikeys.model.ListApiKeysResponse;
import okhttp3.MediaType;

public final class ApiKeys
extends BaseService {
    public ApiKeys(String apiKey) {
        super(apiKey);
    }

    public CreateApiKeyResponse create(CreateApiKeyOptions createApiKeyOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createApiKeyOptions);
        AbstractHttpResponse response = this.httpClient.perform("/api-keys", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to create api key: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        CreateApiKeyResponse createApiKeyResponseResponse = this.resendMapper.readValue(responseBody, CreateApiKeyResponse.class);
        return createApiKeyResponseResponse;
    }

    public ListApiKeysResponse list() throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/api-keys", this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to retrieve api keys: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        ListApiKeysResponse listApiKeysResponse = this.resendMapper.readValue(responseBody, ListApiKeysResponse.class);
        return listApiKeysResponse;
    }

    public boolean remove(String apiKeyId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/api-keys/" + apiKeyId, this.apiKey, HttpMethod.DELETE, "", null);
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to delete api key: " + response.getCode() + " " + (String)response.getBody());
        }
        return true;
    }
}

