/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.batch;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.batch.model.CreateBatchEmailsResponse;
import com.resend.services.emails.model.CreateEmailOptions;
import java.util.List;
import okhttp3.MediaType;

public class Batch
extends BaseService {
    public Batch(String apiKey) {
        super(apiKey);
    }

    public CreateBatchEmailsResponse send(List<CreateEmailOptions> emails) throws ResendException {
        String payload = this.resendMapper.writeValue(emails);
        AbstractHttpResponse response = this.httpClient.perform("/emails/batch", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to send batch emails: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        CreateBatchEmailsResponse createBatchEmailsResponse = this.resendMapper.readValue(responseBody, CreateBatchEmailsResponse.class);
        return createBatchEmailsResponse;
    }

    public CreateBatchEmailsResponse create(List<CreateEmailOptions> emails) throws ResendException {
        return this.send(emails);
    }
}

