/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.emails;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.emails.model.CreateEmailOptions;
import com.resend.services.emails.model.CreateEmailResponse;
import com.resend.services.emails.model.Email;
import okhttp3.MediaType;

public final class Emails
extends BaseService {
    public Emails(String apiKey) {
        super(apiKey);
    }

    public CreateEmailResponse send(CreateEmailOptions createEmailOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createEmailOptions);
        AbstractHttpResponse response = this.httpClient.perform("/emails", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to send email: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        CreateEmailResponse createEmailResponse = this.resendMapper.readValue(responseBody, CreateEmailResponse.class);
        return createEmailResponse;
    }

    public Email get(String emailId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/emails/" + emailId, this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to retrieve email: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        Email email = this.resendMapper.readValue(responseBody, Email.class);
        return email;
    }
}

