/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.domains;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.domains.model.CreateDomainOptions;
import com.resend.services.domains.model.CreateDomainResponse;
import com.resend.services.domains.model.Domain;
import com.resend.services.domains.model.ListDomainsResponse;
import com.resend.services.domains.model.RemoveDomainResponse;
import com.resend.services.domains.model.UpdateDomainOptions;
import com.resend.services.domains.model.UpdateDomainResponseSuccess;
import com.resend.services.domains.model.VerifyDomainResponse;
import okhttp3.MediaType;

public final class Domains
extends BaseService {
    public Domains(String apiKey) {
        super(apiKey);
    }

    public CreateDomainResponse create(CreateDomainOptions createDomainOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createDomainOptions);
        AbstractHttpResponse response = this.httpClient.perform("/domains", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to create domain: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CreateDomainResponse.class);
    }

    public Domain get(String domainId) throws ResendException {
        try {
            AbstractHttpResponse response = this.httpClient.perform("/domains/" + domainId, this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
            if (!response.isSuccessful()) {
                throw new ResendException("Failed to retrieve domain: " + response.getCode() + " " + (String)response.getBody());
            }
            String responseBody = (String)response.getBody();
            return this.resendMapper.readValue(responseBody, Domain.class);
        }
        catch (Exception e) {
            throw new ResendException("Error retrieving domain: " + e.getMessage(), e);
        }
    }

    public VerifyDomainResponse verify(String domainId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/domains/" + domainId + "/verify", this.apiKey, HttpMethod.POST, "", null);
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to verify domain: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, VerifyDomainResponse.class);
    }

    public ListDomainsResponse list() throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/domains", this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to retrieve domains list: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, ListDomainsResponse.class);
    }

    public UpdateDomainResponseSuccess update(UpdateDomainOptions updateDomainOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(updateDomainOptions);
        AbstractHttpResponse response = this.httpClient.perform("/domains/" + updateDomainOptions.getId(), this.apiKey, HttpMethod.PATCH, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to delete domain: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, UpdateDomainResponseSuccess.class);
    }

    public RemoveDomainResponse remove(String domainId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/domains/" + domainId, this.apiKey, HttpMethod.DELETE, "", null);
        if (!response.isSuccessful()) {
            throw new ResendException("Failed to delete domain: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, RemoveDomainResponse.class);
    }
}

