/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.emails;

import com.resend.core.exception.ResendException;
import com.resend.core.net.AbstractHttpResponse;
import com.resend.core.net.HttpMethod;
import com.resend.core.service.BaseService;
import com.resend.services.emails.model.CancelEmailResponse;
import com.resend.services.emails.model.CreateEmailOptions;
import com.resend.services.emails.model.CreateEmailResponse;
import com.resend.services.emails.model.Email;
import com.resend.services.emails.model.UpdateEmailOptions;
import com.resend.services.emails.model.UpdateEmailResponse;
import java.util.Map;
import okhttp3.MediaType;

public final class Emails
extends BaseService {
    public Emails(String apiKey) {
        super(apiKey);
    }

    public CreateEmailResponse send(CreateEmailOptions createEmailOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createEmailOptions);
        AbstractHttpResponse response = this.httpClient.perform("/emails", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to send email: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CreateEmailResponse.class);
    }

    public CreateEmailResponse send(CreateEmailOptions createEmailOptions, Map<String, String> requestOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(createEmailOptions);
        AbstractHttpResponse response = this.httpClient.perform("/emails", this.apiKey, HttpMethod.POST, payload, MediaType.get((String)"application/json"), requestOptions);
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to send email: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CreateEmailResponse.class);
    }

    public Email get(String emailId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/emails/" + emailId, this.apiKey, HttpMethod.GET, null, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to retrieve email: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, Email.class);
    }

    public UpdateEmailResponse update(String emailId, UpdateEmailOptions updateEmailOptions) throws ResendException {
        String payload = this.resendMapper.writeValue(updateEmailOptions);
        AbstractHttpResponse response = this.httpClient.perform("/emails/" + emailId, this.apiKey, HttpMethod.PATCH, payload, MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to update email: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, UpdateEmailResponse.class);
    }

    public CancelEmailResponse cancel(String emailId) throws ResendException {
        AbstractHttpResponse response = this.httpClient.perform("/emails/" + emailId + "/cancel", this.apiKey, HttpMethod.POST, "", MediaType.get((String)"application/json"));
        if (!response.isSuccessful()) {
            throw new RuntimeException("Failed to cancel email schedule: " + response.getCode() + " " + (String)response.getBody());
        }
        String responseBody = (String)response.getBody();
        return this.resendMapper.readValue(responseBody, CancelEmailResponse.class);
    }
}

