/*
 * Decompiled with CFR 0.152.
 */
package com.resend.services.emails.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.resend.services.emails.model.Attachment;
import com.resend.services.emails.model.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateEmailOptions {
    @JsonProperty(value="from")
    private final String from;
    @JsonProperty(value="to")
    private final List<String> to;
    @JsonProperty(value="subject")
    private final String subject;
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="cc")
    private final List<String> cc;
    @JsonProperty(value="bcc")
    private final List<String> bcc;
    @JsonProperty(value="reply_to")
    private final List<String> replyTo;
    @JsonProperty(value="html")
    private final String html;
    @JsonProperty(value="headers")
    private final Map<String, String> headers;
    @JsonProperty(value="attachments")
    private final List<Attachment> attachments;
    @JsonProperty(value="tags")
    private final List<Tag> tags;
    @JsonProperty(value="scheduled_at")
    private final String scheduledAt;

    private CreateEmailOptions(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.text = builder.text;
        this.subject = builder.subject;
        this.cc = builder.cc;
        this.bcc = builder.bcc;
        this.replyTo = builder.replyTo;
        this.attachments = builder.attachments;
        this.tags = builder.tags;
        this.html = builder.html;
        this.headers = builder.headers;
        this.scheduledAt = builder.scheduledAt;
    }

    public String getFrom() {
        return this.from;
    }

    public List<String> getTo() {
        return this.to;
    }

    public String getText() {
        return this.text;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getCc() {
        return this.cc;
    }

    public List<String> getBcc() {
        return this.bcc;
    }

    public List<String> getReplyTo() {
        return this.replyTo;
    }

    public String getHtml() {
        return this.html;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getScheduledAt() {
        return this.scheduledAt;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String from;
        private List<String> to;
        private String text;
        private String subject;
        private List<String> cc;
        private List<String> bcc;
        private List<String> replyTo;
        private String html;
        private List<Attachment> attachments;
        private List<Tag> tags;
        private Map<String, String> headers;
        private String scheduledAt;

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String ... recipients) {
            if (this.to == null) {
                this.to = new ArrayList<String>();
            }
            this.to.addAll(Arrays.asList(recipients));
            return this;
        }

        public Builder to(List<String> recipients) {
            this.to = recipients;
            return this;
        }

        public Builder addTo(String recipient) {
            if (this.to == null) {
                this.to = new ArrayList<String>();
            }
            this.to.add(recipient);
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder cc(String ... recipients) {
            if (this.cc == null) {
                this.cc = new ArrayList<String>();
            }
            this.cc.addAll(Arrays.asList(recipients));
            return this;
        }

        public Builder cc(List<String> cc) {
            if (this.cc == null) {
                this.cc = new ArrayList<String>();
            }
            this.cc.addAll(cc);
            return this;
        }

        public Builder addCc(String recipient) {
            if (this.cc == null) {
                this.cc = new ArrayList<String>();
            }
            this.cc.add(recipient);
            return this;
        }

        public Builder bcc(String ... recipients) {
            if (this.bcc == null) {
                this.bcc = new ArrayList<String>();
            }
            this.bcc.addAll(Arrays.asList(recipients));
            return this;
        }

        public Builder bcc(List<String> recipients) {
            if (this.bcc == null) {
                this.bcc = new ArrayList<String>();
            }
            this.bcc.addAll(recipients);
            return this;
        }

        public Builder addBcc(String recipient) {
            if (this.bcc == null) {
                this.bcc = new ArrayList<String>();
            }
            this.bcc.add(recipient);
            return this;
        }

        public Builder replyTo(String ... recipients) {
            if (this.replyTo == null) {
                this.replyTo = new ArrayList<String>();
            }
            this.replyTo.addAll(Arrays.asList(recipients));
            return this;
        }

        public Builder replyTo(List<String> recipients) {
            if (this.replyTo == null) {
                this.replyTo = new ArrayList<String>();
            }
            this.replyTo.addAll(recipients);
            return this;
        }

        public Builder addReplyTo(String recipient) {
            if (this.replyTo == null) {
                this.replyTo = new ArrayList<String>();
            }
            this.replyTo.add(recipient);
            return this;
        }

        public Builder html(String html) {
            this.html = html;
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder addHeader(String key, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(key, value);
            return this;
        }

        public Builder attachments(Attachment ... attachments) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<Attachment>();
            }
            this.attachments.addAll(Arrays.asList(attachments));
            return this;
        }

        public Builder attachments(List<Attachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder addAttachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList<Attachment>();
            }
            this.attachments.add(attachment);
            return this;
        }

        public Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>();
            }
            this.tags.addAll(Arrays.asList(tags));
            return this;
        }

        public Builder tags(List<Tag> tags) {
            this.tags = tags;
            return this;
        }

        public Builder addTag(Tag tag) {
            if (this.tags == null) {
                this.tags = new ArrayList<Tag>();
            }
            this.tags.add(tag);
            return this;
        }

        public Builder scheduledAt(String scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        public CreateEmailOptions build() {
            return new CreateEmailOptions(this);
        }
    }
}

