/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.apiext.internal.api.configuration;

import com.sap.core.connectivity.apiext.internal.api.configuration.HTML5DestinationMetadata;
import com.sap.core.connectivity.apiext.internal.api.configuration.InvalidHTML5DestinationMetadataException;

public class HTML5DestinationMetadataBuilder {
    private final String providerAccountId;
    private final String applicationName;
    private final String consumerAccountId;
    private final String destination;
    private String subscriptionName;
    private String destinationMappingKey;

    public HTML5DestinationMetadataBuilder(String providerAccountId, String applicationName, String consumerAccountId, String destination) {
        this.providerAccountId = providerAccountId;
        this.applicationName = applicationName;
        this.consumerAccountId = consumerAccountId;
        this.destination = destination;
    }

    public HTML5DestinationMetadataBuilder setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
        return this;
    }

    public HTML5DestinationMetadataBuilder setDestinationMappingKey(String destinationMappingKey) {
        this.destinationMappingKey = destinationMappingKey;
        return this;
    }

    public HTML5DestinationMetadata build() {
        this.validateMetadata();
        return new HTML5DestinationMetadata(this.providerAccountId, this.applicationName, this.consumerAccountId, this.subscriptionName, this.destination, this.destinationMappingKey);
    }

    private void validateMetadata() {
        this.validateNotBlankField(this.providerAccountId, "provider account");
        this.validateNotBlankField(this.applicationName, "application name");
        this.validateNotBlankField(this.consumerAccountId, "consumer account");
        this.validateNotBlankField(this.destination, "destination");
        if (!this.providerAccountId.equals(this.consumerAccountId) && this.isBlank(this.subscriptionName)) {
            throw new InvalidHTML5DestinationMetadataException("Subscription name is required when you have destination on subscription level.");
        }
    }

    private void validateNotBlankField(String fieldValue, String fieldName) throws InvalidHTML5DestinationMetadataException {
        if (this.isBlank(fieldValue)) {
            String errorMessage = String.format("Field [%s] cannot have blank value.", fieldName);
            throw new InvalidHTML5DestinationMetadataException(errorMessage);
        }
    }

    private boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }
}

