/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api;

import com.sap.ecm.api.RepositoryAlreadyExistsException;
import com.sap.ecm.api.RepositoryNotEmptyException;
import com.sap.ecm.api.RepositoryOptions;
import com.sap.ecm.api.RepositoryQuotaExceededException;
import com.sap.ecm.api.ServiceException;
import com.sap.ecm.api.auth.EcmAuthenticationProvider;
import com.sap.ecm.api.internal.SessionLookup;
import com.sap.ecm.api.internal.cert.ClientCertificate;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EcmFactory {
    private static final Logger log = Logger.getLogger(EcmFactory.class);
    private static final String SYSTEM_PROPERTY_ECM_APP_UNIQUE_NAME = "ecm.application.triple";
    private static final String REPID_PREFIX_FOR_UNIQENAME = "@";
    private static final String JSON_APPLICATION_ID = "appId";
    private static final String JSON_REPO_KEY = "key";
    private static final String JSON_REPO_DISPLAY_NAME = "displayName";
    private static final String JSON_REPO_DESCRIPTION = "description";
    private static final String JSON_REPO_VISIBILITY = "visibility";
    private static final String JSON_REPO_MULTITENANT_CAPABLE = "multiTenancy";
    private static final String JSON_REPO_VIRUS_SCANNING = "virusScanning";
    private static final String JSON_REPO_ID = "repositoryId";
    private static final String CODE_PREFIX = "Error code ";
    private static final String CODE_QUOTA_EXCEEDED = "001";
    private static final String CODE_ALREADY_EXISTS = "002";
    private static final String CODE_NOT_EMPTY = "003";

    public static Session connect(String uniqueName, String key) throws ServiceException, CmisObjectNotFoundException {
        return EcmFactory.connectForUser(uniqueName, key, null, null);
    }

    public static Session connectForUser(String uniqueName, String key, String user) throws ServiceException, CmisObjectNotFoundException {
        return EcmFactory.connectForUser(uniqueName, key, null, user);
    }

    public static Session connect(String uniqueName, String key, String destination) throws ServiceException, CmisObjectNotFoundException {
        return EcmFactory.connectForUser(uniqueName, key, destination, null);
    }

    public static Session connect(String uniqueName, String key, String destination, Map<String, String> openCmisProperties) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, null);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        sessionParams.putAll(openCmisProperties);
        String user = openCmisProperties.get("X-EcmUserEnc");
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, sessionParams);
    }

    public static Session connectForUser(String uniqueName, String key, String destination, String user) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, sessionParams);
    }

    public static Session connectForUser(String uniqueName, String key, String destination, String user, Map<String, String> openCmisProperties) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        sessionParams.putAll(openCmisProperties);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, sessionParams);
    }

    public static Session connectForTenant(String uniqueName, String key, String tenantId, String user) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(null, tenantId, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, sessionParams);
    }

    public static Session connectForTenant(String uniqueName, String key, String tenantId, String user, Map<String, String> openCmisProperties) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(null, tenantId, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        sessionParams.putAll(openCmisProperties);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, sessionParams);
    }

    public static String createRepository(RepositoryOptions options) throws ServiceException, RepositoryAlreadyExistsException {
        return EcmFactory.createRepository(options, null);
    }

    public static String createRepository(RepositoryOptions options, String destination) throws ServiceException, RepositoryAlreadyExistsException {
        SessionLookup sl = new SessionLookup(destination, null, null);
        return EcmFactory.createRepositoryInternal(options, sl);
    }

    private static String createRepositoryInternal(RepositoryOptions options, SessionLookup sl) throws ServiceException, RepositoryAlreadyExistsException, RepositoryQuotaExceededException {
        if (options == null) {
            throw new CmisInvalidArgumentException("Cannot create repository without any options. Parameter options cannot be null");
        }
        String error = options.validate();
        if (error != null) {
            throw new ServiceException("RepositoryOptions object not valid: " + error);
        }
        RepositoryOptions.Visibility visibility = options.getVisibility();
        if (visibility == RepositoryOptions.Visibility.PRIVATE) {
            throw new ServiceException("Cannot create a repository with visibility Visibility.PRIVATE. Not implemented yet...");
        }
        String jsonString = EcmFactory.buildJsonRequest(options);
        String uniqueRepositoryName = options.getUniqueName();
        uniqueRepositoryName = EcmFactory.urlEncode(uniqueRepositoryName);
        String repoCreationUrl = EcmFactory.computeRepoCreationUrl(sl, uniqueRepositoryName);
        try {
            ClientCertificate clientCert;
            SSLSocketFactory sf;
            URL url = new URL(repoCreationUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            if (connection instanceof HttpsURLConnection && (sf = (clientCert = new ClientCertificate()).getSSLSocketFactory()) != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(sf);
            }
            OutputStream out = connection.getOutputStream();
            byte[] jsonBytes = jsonString.getBytes("utf-8");
            out.write(jsonBytes);
            out.close();
            connection.connect();
            int httpStatusCode = connection.getResponseCode();
            if (httpStatusCode != 201) {
                String errorResponse = EcmFactory.convertToStringAndClose(connection.getErrorStream());
                if (httpStatusCode == 409) {
                    if (errorResponse.startsWith("Error code 002")) {
                        log.info((Object)("Could not create repository with uniqueName " + options.getUniqueName() + "as it already exists. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                        throw new RepositoryAlreadyExistsException("Repository with uniqueName " + options.getUniqueName() + " already exists.");
                    }
                    if (errorResponse.startsWith("Error code 001")) {
                        log.info((Object)("Could not create repository with uniqueName " + options.getUniqueName() + "as repository quota is exceeded. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                        throw new RepositoryQuotaExceededException("Repository quota exceeded.");
                    }
                    log.error((Object)("Could not create repository with uniqueName " + options.getUniqueName() + ". Unparsed error. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                    throw new ServiceException("Could not create repository with uniqueName " + options.getUniqueName());
                }
                log.error((Object)("Could not create repository, document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                throw new ServiceException("Could not create repository. Document Service responded with http " + httpStatusCode + "(see the logs for details)");
            }
            String result = EcmFactory.convertToStringAndClose(connection.getInputStream());
            try {
                JSONObject jsonResult = EcmFactory.parseJsonResponse(result);
                String repoId = (String)jsonResult.get((Object)JSON_REPO_ID);
                log.info((Object)("Created new repository with name '" + uniqueRepositoryName + "' with isolation '" + visibility.name() + "' and id '" + repoId + "'."));
                return repoId;
            }
            catch (Exception e) {
                log.error((Object)("Could not parse response to json: " + result), (Throwable)e);
                throw new ServiceException("Could not create repository. Got this response from document service: " + result, e);
            }
        }
        catch (IOException e) {
            throw new ServiceException("Cannot process request to Document Service to create a new repository (see contained exception)", e);
        }
    }

    public static void deleteRepository(String uniqueName, String repositoryKey) throws ServiceException, CmisObjectNotFoundException, RepositoryNotEmptyException {
        EcmFactory.deleteRepository(uniqueName, repositoryKey, null);
    }

    public static void deleteRepository(String uniqueName, String repositoryKey, String destination) throws ServiceException, CmisObjectNotFoundException, RepositoryNotEmptyException {
        SessionLookup sl = new SessionLookup(destination, null, null);
        EcmFactory.deleteRepositoryInternal(sl, uniqueName, repositoryKey, destination);
    }

    private static void deleteRepositoryInternal(SessionLookup sl, String uniqueName, String repositoryKey, String destination) throws ServiceException, CmisObjectNotFoundException, RepositoryNotEmptyException {
        if (uniqueName == null || uniqueName.length() <= 0) {
            throw new CmisInvalidArgumentException("Repository UniqueName mising.");
        }
        if (repositoryKey == null || repositoryKey.length() <= 0) {
            throw new CmisInvalidArgumentException("Repository Key mising.");
        }
        String repoCreationUrl = EcmFactory.computeRepoCreationUrl(sl, uniqueName);
        try {
            ClientCertificate clientCert;
            SSLSocketFactory sf;
            URL url = new URL(repoCreationUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("DELETE");
            connection.addRequestProperty("X-EcmRepKeyEnc", repositoryKey);
            if (connection instanceof HttpsURLConnection && (sf = (clientCert = new ClientCertificate()).getSSLSocketFactory()) != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(sf);
            }
            connection.connect();
            int httpStatusCode = connection.getResponseCode();
            if (httpStatusCode != 200) {
                String errorResponse = EcmFactory.convertToStringAndClose(connection.getErrorStream());
                if (httpStatusCode == 404) {
                    log.info((Object)("Could not delete repository with uniqueName " + uniqueName + "as it does not exist. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                    throw new CmisObjectNotFoundException("Repository with uniqueName " + uniqueName + " does not exist.");
                }
                if (httpStatusCode == 403) {
                    if (errorResponse.startsWith("Error code 003")) {
                        log.info((Object)("Could not delete repository with uniqueName " + uniqueName + "as it still contains content. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                        throw new RepositoryNotEmptyException("Repository with uniqueName " + uniqueName + " is not empty.");
                    }
                    log.error((Object)("Could not delete repository, document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                    throw new ServiceException("Could not delete. Document Service responded with http " + httpStatusCode + "(see the logs for details)");
                }
                log.error((Object)("Could not delete repository, document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                throw new ServiceException("Could not delete repository. Document Service responded with http " + httpStatusCode + "(see the logs for details)");
            }
            String result = EcmFactory.convertToStringAndClose(connection.getInputStream());
            log.info((Object)("Deleted repository with name '" + uniqueName + " Response: " + result));
        }
        catch (IOException e) {
            throw new ServiceException("Cannot process request to Document Service to delete a repository (see contained exception)", e);
        }
    }

    private static String buildJsonRequest(RepositoryOptions options) {
        JSONObject json = new JSONObject();
        json.put((Object)JSON_APPLICATION_ID, (Object)EcmFactory.getAppId(null));
        json.put((Object)JSON_REPO_VISIBILITY, (Object)options.getVisibility().name().toLowerCase(Locale.ENGLISH));
        json.put((Object)JSON_REPO_MULTITENANT_CAPABLE, (Object)Boolean.toString(options.isMultiTenantCapable()));
        json.put((Object)JSON_REPO_VIRUS_SCANNING, (Object)Boolean.toString(options.isVirusScannerEnabled()));
        if (options.getDisplayName() != null) {
            json.put((Object)JSON_REPO_DISPLAY_NAME, (Object)options.getDisplayName());
        }
        if (options.getDescription() != null) {
            json.put((Object)JSON_REPO_DESCRIPTION, (Object)options.getDescription());
        }
        if (options.getRepositoryKey() != null) {
            json.put((Object)JSON_REPO_KEY, (Object)options.getRepositoryKey());
        }
        return json.toJSONString();
    }

    private static JSONObject parseJsonResponse(String response) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject json = (JSONObject)parser.parse(response);
        return json;
    }

    private static String computeRepoCreationUrl(SessionLookup sl, String uniqueRepositoryName) {
        String ecmServerUrl = sl.getEcmServerUrl();
        int i = ecmServerUrl.indexOf("/", "https://".length());
        if (i == -1) {
            i = ecmServerUrl.length();
        }
        if ((i = ecmServerUrl.indexOf("/", i + 1)) == -1) {
            i = ecmServerUrl.length();
        }
        return String.valueOf(ecmServerUrl.substring(0, i)) + "/repo/" + uniqueRepositoryName;
    }

    private static Session connectInternal(String repositoryId, String uniqueName, String repKey, SessionLookup sl, String user, Map<String, String> sessionParams) {
        if (!sessionParams.containsKey("org.apache.chemistry.opencmis.session.repository.id")) {
            sessionParams.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
        }
        if (repKey != null && !sessionParams.containsKey("X-EcmRepKeyEnc")) {
            sessionParams.put("X-EcmRepKeyEnc", repKey);
        }
        if (!sessionParams.containsKey("X-EcmRepUniqueNameEnc")) {
            if (repositoryId.startsWith(REPID_PREFIX_FOR_UNIQENAME)) {
                sessionParams.put("X-EcmRepUniqueNameEnc", repositoryId.substring(1, repositoryId.length()));
            } else {
                sessionParams.put("X-EcmRepUniqueNameEnc", uniqueName);
            }
        }
        if (!sessionParams.containsKey("X-EcmUserEnc")) {
            if (user != null) {
                sessionParams.put("X-EcmUserEnc", user);
            } else {
                user = sl.getUser();
                if (user != null) {
                    sessionParams.put("X-EcmUserEnc", user);
                }
            }
        }
        if (sl.getTenantId() != null && !sessionParams.containsKey("SAP-Tenant-Id")) {
            sessionParams.put("SAP-Tenant-Id", sl.getTenantId());
        }
        SessionFactory sessionFactory = SessionLookup.getOpenCmisSessionFactory();
        Session session = sessionFactory.createSession(sessionParams);
        return session;
    }

    private static Map<String, String> buildSessionParams(SessionLookup sessionLookup) {
        HashMap<String, String> sessionParams = new HashMap<String, String>();
        sessionParams.put("org.apache.chemistry.opencmis.binding.cookies", "true");
        sessionParams.put("org.apache.chemistry.opencmis.binding.auth.classname", EcmAuthenticationProvider.class.getName());
        if (sessionLookup.getEcmServerUrl().endsWith("/json") || sessionLookup.getEcmServerUrl().endsWith("/json/")) {
            sessionParams.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.BROWSER.value());
            sessionParams.put("org.apache.chemistry.opencmis.binding.browser.url", sessionLookup.getEcmServerUrl());
        } else {
            sessionParams.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            sessionParams.put("org.apache.chemistry.opencmis.binding.atompub.url", sessionLookup.getEcmServerUrl());
        }
        return sessionParams;
    }

    private static String getAppId(String applianceTriple) {
        String tripleInfo = applianceTriple;
        if (tripleInfo == null || tripleInfo.length() == 0) {
            tripleInfo = System.getProperty(SYSTEM_PROPERTY_ECM_APP_UNIQUE_NAME);
        }
        if (tripleInfo == null || tripleInfo.length() == 0) {
            tripleInfo = EcmFactory.getSystemTripleInformationInCloud();
        }
        if (tripleInfo == null || tripleInfo.length() == 0) {
            tripleInfo = "local_space;local_app;local_comp";
        }
        return tripleInfo;
    }

    private static String getSystemTripleInformationInCloud() {
        Properties p = new Properties();
        String path = null;
        try {
            p.load(new FileInputStream("space.properties"));
            path = String.valueOf(p.getProperty("jpSpace")) + ";" + p.getProperty("jpApp") + ";" + p.getProperty("component");
        }
        catch (FileNotFoundException e) {
            log.info((Object)"Could not load triple info from space.properties (not found).", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Could not load triple info from space.properties", (Throwable)e);
        }
        return path;
    }

    private static String convertToStringAndClose(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder writer = new StringBuilder();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                while ((n = reader.read(buffer)) != -1) {
                    writer.append(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return writer.toString();
        }
        return null;
    }

    private static String urlEncode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("UTF-8 is an unknown encoding...", e);
        }
    }
}

