/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.oauth2;

import com.sap.cloud.security.oauth2.OAuthAuthorization;
import com.sap.cloud.security.oauth2.OAuthSystemException;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAuthorizationFilter
implements Filter {
    private String scope;
    private String httpMethod;
    private String userPrincipal;
    private static final Logger logger = LoggerFactory.getLogger(OAuthAuthorizationFilter.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isAthorize = false;
        if (this.httpMethod != null && !this.httpMethod.equalsIgnoreCase(httpRequest.getMethod())) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        try {
            OAuthAuthorization authorization = this.getOAuthAuthorizationService();
            if (authorization == null) {
                throw new OAuthSystemException("Couldn't get OAuthAuthorizationService object.");
            }
            isAthorize = authorization.isAuthorized(httpRequest, this.scope);
        }
        catch (OAuthSystemException e) {
            httpResponse.sendError(500);
            if (!logger.isDebugEnabled()) return;
            logger.debug("Internal server error when checking the authorization. " + e.getMessage(), (Throwable)e);
            return;
        }
        if (isAthorize) {
            if (!new Boolean(this.userPrincipal).equals(Boolean.TRUE)) {
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                return;
            }
            String userid = (String)httpRequest.getAttribute("user_id");
            if (logger.isDebugEnabled()) {
                logger.debug("user_principal is true. getUserPrincipal method has to return the user from the token.");
            }
            OAuthRequestWrapper requestWrapper = new OAuthRequestWrapper(userid, httpRequest);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)httpResponse);
            return;
        }
        Object reasonAttribute = httpRequest.getAttribute("reason");
        if (reasonAttribute != null && ((String)reasonAttribute).equals("access_forbidden")) {
            httpResponse.sendError(403);
            return;
        }
        httpResponse.sendError(401);
    }

    public void init(FilterConfig config) throws ServletException {
        this.scope = config.getInitParameter("scope");
        this.httpMethod = config.getInitParameter("http-method");
        this.userPrincipal = config.getInitParameter("user-principal");
    }

    public void destroy() {
        this.scope = null;
        this.httpMethod = null;
    }

    OAuthAuthorization getOAuthAuthorizationService() {
        return OAuthAuthorization.getOAuthAuthorizationService();
    }

    private class OAuthRequestWrapper
    extends HttpServletRequestWrapper {
        private String userid;

        public OAuthRequestWrapper(String userid, HttpServletRequest request) {
            super(request);
            this.userid = userid;
        }

        public Principal getUserPrincipal() {
            return new Principal(){

                @Override
                public String getName() {
                    return OAuthRequestWrapper.this.userid;
                }
            };
        }

        public String getRemoteUser() {
            return this.userid;
        }

        public boolean isUserInRole(String role) {
            return false;
        }
    }
}

