/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api;

import com.sap.ecm.api.ServiceException;
import com.sap.ecm.api.auth.EcmAuthenticationProvider;
import com.sap.ecm.api.internal.SessionLookup;
import com.sap.ecm.api.internal.cert.ClientCertificate;
import com.sap.security.auth.login.LoginContextFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class AbstractCmisProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String uuid = UUID.randomUUID().toString();
    private static final Logger LOG = Logger.getLogger(AbstractCmisProxyServlet.class);
    private static final String HTTPHEADER_X_ECMREPUNIQUENAME = "X-EcmRepUniqueNameEnc";
    private static final String HTTPHEADER_X_ECMREPKEY = "X-EcmRepKeyEnc";
    private static final String HTTPHEADER_X_CMIS_BASE_URL = "X-CmisBaseUrl";
    private static final String HTTPHEADER_X_ECM_USER = "X-EcmUserEnc";
    private static final String SESSION_ECM_COOKIES = "com.sap.ecm.api.ecm.cookies";
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private static final int BUFFER_SIZE = 4096;
    private SSLSocketFactory sslSocketFactory;
    private static Map<String, String> repoNameUrlMap = new HashMap<String, String>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.sslSocketFactory = new ClientCertificate().getSSLSocketFactory();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String method = request.getMethod();
        if (!this.checkMethod(method)) {
            response.sendError(400);
            return;
        }
        String path = this.extractPath(request);
        if (!this.checkPath(path)) {
            response.sendError(404);
            return;
        }
        if (this.readOnlyMode() && !method.equals("GET")) {
            response.setStatus(405);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            PrintWriter pw = response.getWriter();
            pw.println("{\"exception\": \"notSupported\", \"message\": \"Only read operations are supported!\"}");
            return;
        }
        HttpSession session = request.getSession();
        String query = request.getQueryString();
        String reqHost = request.getServerName();
        String ecmBaseUrl = this.getBaseUrl(this.getRepositoryUniqueNameNoException(), reqHost);
        if (ecmBaseUrl == null) {
            ecmBaseUrl = this.findEcmUrl();
            this.setBaseUrl(this.getRepositoryUniqueNameNoException(), reqHost, ecmBaseUrl);
        }
        String url = String.valueOf(ecmBaseUrl) + path + (query != null ? "?" + query : "");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Forwarding request to: " + url));
        }
        String user = null;
        boolean isWsdlRequest = this.isWebServicesWsdl(method, path);
        if (!isWsdlRequest && this.requireAuthentication()) {
            try {
                user = this.authenticate(request, response);
            }
            catch (LoginException le) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Login error. URL: " + url), (Throwable)le);
                }
                return;
            }
            catch (Exception e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Authentication error. URL: " + url), (Throwable)e);
                }
                this.sendCMISProxyError(request, response, "CMIS Proxy login error.");
                return;
            }
        }
        try {
            String cookieStr;
            URL oldURL = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)oldURL.openConnection();
            conn.setRequestMethod(request.getMethod());
            conn.setDoInput(true);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(false);
            conn.setConnectTimeout(this.getConnectTimeout());
            conn.setReadTimeout(this.getReadTimeout());
            if (conn instanceof HttpsURLConnection && this.sslSocketFactory != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
            }
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                if (!this.isHeaderAllowedToForward(headerName)) continue;
                Enumeration values = request.getHeaders(headerName);
                while (values.hasMoreElements()) {
                    conn.addRequestProperty(headerName, (String)values.nextElement());
                }
            }
            String repositoryUniqueName = this.getRepositoryUniqueName();
            if (!this.checkNameOrKey(repositoryUniqueName)) {
                throw new ServiceException("Invalid repository unique name!");
            }
            String repositoryKey = this.getRepositoryKey();
            if (!this.checkNameOrKey(repositoryKey)) {
                throw new ServiceException("Invalid repository key!");
            }
            if (repositoryUniqueName != null && repositoryKey == null) {
                throw new ServiceException("Repository key not set!");
            }
            if (repositoryUniqueName != null) {
                conn.setRequestProperty(HTTPHEADER_X_ECMREPUNIQUENAME, EcmAuthenticationProvider.encodeUTF8((String)repositoryUniqueName));
                conn.setRequestProperty(HTTPHEADER_X_ECMREPKEY, EcmAuthenticationProvider.encodeUTF8((String)repositoryKey));
            }
            conn.setRequestProperty(HTTPHEADER_X_CMIS_BASE_URL, EcmAuthenticationProvider.encodeUTF8((String)this.getProxyBaseUrl(request)));
            if (user != null) {
                conn.setRequestProperty(HTTPHEADER_X_ECM_USER, EcmAuthenticationProvider.encodeUTF8((String)user));
            }
            if ((cookieStr = (String)session.getAttribute(SESSION_ECM_COOKIES)) != null) {
                conn.setRequestProperty("Cookie", cookieStr);
            }
            if (this.mayHaveContent(request)) {
                conn.setDoOutput(true);
                conn.setChunkedStreamingMode(65535);
                OutputStream out = conn.getOutputStream();
                this.copyStream((InputStream)request.getInputStream(), out, AbstractCmisProxyServlet.isFormUrlencodedContent(request));
                out.flush();
            } else {
                conn.setDoOutput(false);
            }
            conn.connect();
            response.setStatus(conn.getResponseCode());
            URL newUrl = conn.getURL();
            if (!oldURL.getHost().equals(newUrl.getHost())) {
                URL ecmBaseUrlAsURL = new URL(ecmBaseUrl);
                URL newEcmBaseUrl = new URL(ecmBaseUrlAsURL.getProtocol(), newUrl.getHost(), ecmBaseUrlAsURL.getPort(), ecmBaseUrlAsURL.getFile());
                this.setBaseUrl(repositoryUniqueName, reqHost, newEcmBaseUrl.toExternalForm());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("followed redirect, oldEcmBaseUrl=" + ecmBaseUrl + ", new=" + newEcmBaseUrl.toExternalForm()));
                }
            }
            ArrayList<String> cookies = new ArrayList<String>();
            for (Map.Entry<String, List<String>> header : conn.getHeaderFields().entrySet()) {
                String lowerHeaderName;
                if (header.getKey() == null || (lowerHeaderName = header.getKey().toLowerCase(Locale.ENGLISH)).equals("transfer-encoding") || lowerHeaderName.equals("connection") || lowerHeaderName.equals("content-length") || lowerHeaderName.equals("via")) continue;
                for (String value : header.getValue()) {
                    if (lowerHeaderName.equals("set-cookie")) {
                        cookies.add(value);
                        continue;
                    }
                    response.addHeader(header.getKey(), value);
                }
            }
            if (!cookies.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (String cookie : cookies) {
                    int x;
                    if (sb.length() > 0) {
                        sb.append("; ");
                    }
                    if ((x = cookie.indexOf(59)) >= 0) {
                        sb.append(cookie.substring(0, x).trim());
                        continue;
                    }
                    sb.append(cookie.trim());
                }
                session.setAttribute(SESSION_ECM_COOKIES, (Object)sb.toString());
            }
            if (conn.getContentLength() != 0) {
                InputStream stream = conn.getErrorStream();
                if (stream == null) {
                    stream = conn.getInputStream();
                }
                if (stream != null) {
                    ServletOutputStream out = response.getOutputStream();
                    this.copyStream(stream, (OutputStream)out, false);
                    stream.close();
                    out.flush();
                }
            }
        }
        catch (SocketTimeoutException ste) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Timeout connecting to: " + url), (Throwable)ste);
            }
            this.sendCMISProxyError(request, response, "CMIS Proxy timeout.");
        }
        catch (Exception e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Communication error. URL: " + url), (Throwable)e);
            }
            this.sendCMISProxyError(request, response, "CMIS Proxy communication error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBaseUrl(String repositoryUniqueName, String reqHost) {
        String key = this.generateKey(repositoryUniqueName, reqHost);
        Map<String, String> map = repoNameUrlMap;
        synchronized (map) {
            return repoNameUrlMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBaseUrl(String repositoryUniqueName, String reqHost, String ecmBaseUrl) {
        String key = this.generateKey(repositoryUniqueName, reqHost);
        Map<String, String> map = repoNameUrlMap;
        synchronized (map) {
            repoNameUrlMap.put(key, ecmBaseUrl);
        }
    }

    private String generateKey(String repositoryUniqueName, String reqHost) {
        return String.valueOf(repositoryUniqueName) + "," + reqHost;
    }

    private String getRepositoryUniqueNameNoException() {
        try {
            String repositoryUniqueName = this.getRepositoryUniqueName();
            if (repositoryUniqueName == null) {
                return "null_" + uuid;
            }
            return repositoryUniqueName;
        }
        catch (Exception exception) {
            return "exception_" + uuid;
        }
    }

    private boolean isHeaderAllowedToForward(String headerName) {
        if (headerName == null || headerName.length() == 0) {
            return false;
        }
        String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
        if ("X-EcmAddPrincipals".toLowerCase(Locale.ENGLISH).equals(lowerHeaderName)) {
            return true;
        }
        return !lowerHeaderName.startsWith("x-") && !lowerHeaderName.startsWith("sap-") && !lowerHeaderName.startsWith("cookie") && !lowerHeaderName.startsWith("authorization");
    }

    protected String getDestinationName() {
        return null;
    }

    protected abstract String getRepositoryUniqueName();

    protected abstract String getRepositoryKey();

    protected boolean supportWebServicesBinding() {
        return true;
    }

    protected boolean supportAtomPubBinding() {
        return true;
    }

    protected boolean supportBrowserBinding() {
        return true;
    }

    protected boolean supportCMIS_1_0() {
        return true;
    }

    protected boolean supportCMIS_1_1() {
        return true;
    }

    protected boolean requireAuthentication() {
        return true;
    }

    protected String authenticate(HttpServletRequest request, HttpServletResponse response) throws LoginException {
        String user = request.getRemoteUser();
        if (user == null) {
            LoginContext loginContext = LoginContextFactory.createLoginContext("BASIC");
            loginContext.login();
            user = request.getRemoteUser();
        }
        return user;
    }

    protected boolean readOnlyMode() {
        return false;
    }

    protected int getConnectTimeout() {
        return 30000;
    }

    protected int getReadTimeout() {
        return 300000;
    }

    private void copyStream(InputStream in, OutputStream out, boolean failOnEmptyInputStream) throws IOException {
        boolean streamIsEmpty = true;
        byte[] buffer = new byte[4096];
        int b = 0;
        while ((b = in.read(buffer)) > -1) {
            out.write(buffer, 0, b);
            if (!streamIsEmpty || b <= 0) continue;
            streamIsEmpty = false;
        }
        if (failOnEmptyInputStream && streamIsEmpty) {
            LOG.error((Object)"The body of the request was empty, although this is not allowed in this case. Maybe you consumed the body by accident? In any case, this request will fail on the document service ...");
        }
    }

    private boolean mayHaveContent(HttpServletRequest request) {
        return request.getMethod().equals("POST") || request.getMethod().equals("PUT");
    }

    private String extractPath(HttpServletRequest request) {
        int prefixLength = request.getContextPath().length() + request.getServletPath().length();
        return request.getRequestURI().substring(prefixLength);
    }

    private String getProxyBaseUrl(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme());
        sb.append("://");
        sb.append(request.getServerName());
        sb.append(':');
        sb.append(request.getServerPort());
        sb.append(request.getContextPath());
        sb.append(request.getServletPath());
        return sb.toString();
    }

    private boolean isAtomBinding(String path) {
        return path != null && (this.supportCMIS_1_0() && (path.equals("/atom") || path.startsWith("/atom/")) || this.supportCMIS_1_1() && (path.equals("/1.1/atom") || path.startsWith("/1.1/atom/")));
    }

    private boolean isBrowserBinding(String path) {
        return path != null && (this.supportCMIS_1_0() && (path.equals("/json") || path.startsWith("/json/")) || this.supportCMIS_1_1() && (path.equals("/1.1/json") || path.startsWith("/1.1/json/")));
    }

    private boolean isWebServicesBinding(String path) {
        return path != null && (this.supportCMIS_1_0() && path.startsWith("/services/") || this.supportCMIS_1_1() && path.startsWith("/1.1/services/"));
    }

    private boolean isWebServicesWsdl(String method, String path) {
        return "GET".equals(method) && this.isWebServicesBinding(path) && (path.endsWith("?wsdl") || path.endsWith("?core") || path.endsWith("?msg"));
    }

    private boolean checkPath(String path) {
        return this.supportAtomPubBinding() && !this.readOnlyMode() && this.isAtomBinding(path) || this.supportBrowserBinding() && this.isBrowserBinding(path) || this.supportWebServicesBinding() && !this.readOnlyMode() && this.isWebServicesBinding(path);
    }

    private boolean checkMethod(String method) {
        return method.equals("GET") || method.equals("POST") || method.equals("PUT") || method.equals("DELETE");
    }

    private void sendCMISProxyError(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        response.setStatus(500);
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        String path = this.extractPath(request);
        if (this.isAtomBinding(path)) {
            response.setContentType("text/html; charset=utf-8");
            pw.print("<html><head><title>CMIS Proxy Error</title></head><body>");
            pw.print("<h1>HTTP Status 500 - <!--exception-->runtime<!--/exception--></h1>");
            pw.print("<p><!--message-->" + message + "<!--/message--></p>");
            pw.println("</body></html>");
        } else if (this.isBrowserBinding(path)) {
            response.setContentType("application/json; charset=utf-8");
            pw.println("{\"exception\": \"runtime\", \"message\": \"" + message + "\"}");
        } else if (this.isWebServicesBinding(path)) {
            if (request.getMethod().equals("GET")) {
                response.setContentType("text/plain; charset=utf-8");
                pw.println(message);
            } else {
                response.setContentType("text/xml; charset=utf-8");
                pw.println("<?xml version='1.0' encoding='UTF-8'?>");
                pw.println("<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\">");
                pw.println("<S:Body>");
                pw.println("<S:Fault>");
                pw.println("<faultcode>S:Server</faultcode>");
                pw.println("<faultstring>" + message + "</faultstring>");
                pw.println("<detail>");
                pw.println("<cmisFault xmlns=\"http://docs.oasis-open.org/ns/cmis/messaging/200908/\">");
                pw.println("<type>runtime</type>");
                pw.println("<code>0</code>");
                pw.println("<message>" + message + "</message>");
                pw.println("</cmisFault>");
                pw.println("</detail>");
                pw.println("</S:Fault>");
                pw.println("</S:Body>");
                pw.println("</S:Envelope>");
            }
        } else {
            response.setContentType("text/plain; charset=utf-8");
            pw.println(message);
        }
        pw.flush();
    }

    private boolean checkNameOrKey(String s) {
        if (s == null) {
            return true;
        }
        if (s.length() < 1 || s.length() > 1024) {
            return false;
        }
        return s.indexOf(10) <= -1 && s.indexOf(13) <= -1;
    }

    private String findEcmUrl() {
        SessionLookup sessionLookup = new SessionLookup(this.getDestinationName(), null, null);
        String ecmUrl = sessionLookup.getEcmServerUrl().trim();
        if (ecmUrl.endsWith("/")) {
            ecmUrl = ecmUrl.substring(0, ecmUrl.length() - 2);
        }
        int x = ecmUrl.lastIndexOf(47);
        return ecmUrl.substring(0, x);
    }

    private static final boolean isFormUrlencodedContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("application/x-www-form-urlencoded");
    }
}

