/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api;

import com.sap.ecm.api.RepositoryAlreadyExistsException;
import com.sap.ecm.api.RepositoryNotEmptyException;
import com.sap.ecm.api.RepositoryOptions;
import com.sap.ecm.api.RepositoryQuotaExceededException;
import com.sap.ecm.api.ServiceException;
import com.sap.ecm.api.auth.EcmAuthenticationProvider;
import com.sap.ecm.api.internal.SessionLookup;
import com.sap.ecm.api.internal.cert.ClientCertificate;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EcmFactory {
    private static final String MAX_RETRIES = "maxRetries";
    private static final String SLEEP_DURATION = "sleepDuration";
    private static final Logger log = Logger.getLogger(EcmFactory.class);
    private static final String SYSTEM_PROPERTY_ECM_APP_UNIQUE_NAME = "ecm.application.triple";
    private static final String REPID_PREFIX_FOR_UNIQENAME = "@";
    private static final String JSON_APPLICATION_ID = "appId";
    private static final String JSON_REPO_KEY = "key";
    private static final String JSON_REPO_DISPLAY_NAME = "displayName";
    private static final String JSON_REPO_DESCRIPTION = "description";
    private static final String JSON_REPO_VISIBILITY = "visibility";
    private static final String JSON_REPO_MULTITENANT_CAPABLE = "multiTenancy";
    private static final String JSON_REPO_VIRUS_SCANNING = "virusScanning";
    private static final String JSON_REPO_ID = "repositoryId";
    private static final String CODE_PREFIX = "Error code ";
    private static final String CODE_QUOTA_EXCEEDED = "001";
    private static final String CODE_ALREADY_EXISTS = "002";
    private static final String CODE_NOT_EMPTY = "003";
    private static final char REPLACED_CHAR = ' ';
    private static final char REPLACEMENT_CHAR = '&';
    private static final char ESCAPE_CHAR = '+';
    private static final int REQUEST_CONNECT_TIMEOUT = 30000;
    private static final int REQUEST_READ_TIMEOUT = 60000;

    public static Session connect(String uniqueName, String key) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(null, null, null);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, null, null, sessionParams);
    }

    public static Session connectForUser(String uniqueName, String key, String user) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(null, null, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, null, sessionParams);
    }

    public static Session connect(String uniqueName, String key, String destination) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, null);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, null, null, sessionParams);
    }

    public static Session connect(String uniqueName, String key, String destination, Map<String, String> openCmisProperties) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, null);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        String user = null;
        if (openCmisProperties != null) {
            sessionParams.putAll(openCmisProperties);
            user = openCmisProperties.get("X-EcmUserEnc");
        }
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, null, sessionParams);
    }

    public static Session connect(String uniqueName, String key, String destination, Map<String, String> openCmisProperties, List<String> additionalPrincipals) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, null);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        String user = null;
        if (openCmisProperties != null) {
            sessionParams.putAll(openCmisProperties);
            user = openCmisProperties.get("X-EcmUserEnc");
        }
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, additionalPrincipals, sessionParams);
    }

    public static Session connectForUser(String uniqueName, String key, String destination, String user) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, null, sessionParams);
    }

    public static Session connectForUser(String uniqueName, String key, String destination, String user, Map<String, String> openCmisProperties) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        if (openCmisProperties != null) {
            sessionParams.putAll(openCmisProperties);
        }
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, null, sessionParams);
    }

    public static Session connectForUser(String uniqueName, String key, String destination, String user, Map<String, String> openCmisProperties, List<String> additionalPrincipals) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(destination, null, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        if (openCmisProperties != null) {
            sessionParams.putAll(openCmisProperties);
        }
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, additionalPrincipals, sessionParams);
    }

    public static Session connectForTenant(String uniqueName, String key, String tenantId, String user) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(null, tenantId, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, null, sessionParams);
    }

    public static Session connectForTenant(String uniqueName, String key, String tenantId, String user, Map<String, String> openCmisProperties) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(null, tenantId, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        if (openCmisProperties != null) {
            sessionParams.putAll(openCmisProperties);
        }
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, null, sessionParams);
    }

    public static Session connectForTenant(String uniqueName, String key, String tenantId, String user, Map<String, String> openCmisProperties, List<String> additionalPrincipals) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup sl = new SessionLookup(null, tenantId, user);
        Map<String, String> sessionParams = EcmFactory.buildSessionParams(sl);
        if (openCmisProperties != null) {
            sessionParams.putAll(openCmisProperties);
        }
        return EcmFactory.connectInternal(REPID_PREFIX_FOR_UNIQENAME + uniqueName, uniqueName, key, sl, user, additionalPrincipals, sessionParams);
    }

    public static String createRepository(RepositoryOptions options) throws ServiceException, RepositoryAlreadyExistsException {
        return EcmFactory.createRepository(options, null);
    }

    public static String createRepository(RepositoryOptions options, String destination) throws ServiceException, RepositoryAlreadyExistsException {
        SessionLookup sl = new SessionLookup(destination, null, null);
        return EcmFactory.createRepositoryInternal(options, sl);
    }

    private static String createRepositoryInternal(RepositoryOptions options, SessionLookup sl) throws ServiceException, RepositoryAlreadyExistsException, RepositoryQuotaExceededException {
        if (options == null) {
            throw new CmisInvalidArgumentException("Cannot create repository without any options. Parameter options cannot be null");
        }
        String error = options.validate();
        if (error != null) {
            throw new ServiceException("RepositoryOptions object not valid: " + error);
        }
        RepositoryOptions.Visibility visibility = options.getVisibility();
        if (visibility == RepositoryOptions.Visibility.PRIVATE) {
            throw new ServiceException("Cannot create a repository with visibility Visibility.PRIVATE. Not implemented yet...");
        }
        String jsonString = EcmFactory.buildJsonRequest(options);
        String uniqueRepositoryName = options.getUniqueName();
        uniqueRepositoryName = EcmFactory.urlEncode(uniqueRepositoryName);
        String repoCreationUrl = EcmFactory.computeRepositoryUrl(sl, uniqueRepositoryName);
        HttpURLConnection connection = null;
        try {
            ClientCertificate clientCert;
            SSLSocketFactory sf;
            URL url = new URL(repoCreationUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(60000);
            if (connection instanceof HttpsURLConnection && (sf = (clientCert = new ClientCertificate()).getSSLSocketFactory()) != null) {
                ((HttpsURLConnection)connection).setSSLSocketFactory(sf);
            }
            OutputStream out = connection.getOutputStream();
            byte[] jsonBytes = jsonString.getBytes("utf-8");
            out.write(jsonBytes);
            out.close();
            connection.connect();
            int httpStatusCode = connection.getResponseCode();
            if (httpStatusCode != 201) {
                String errorResponse = EcmFactory.convertToStringAndClose(connection.getErrorStream());
                if (httpStatusCode == 409) {
                    if (errorResponse.startsWith("Error code 002")) {
                        log.info((Object)("Could not create repository with uniqueName " + options.getUniqueName() + "as it already exists. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                        throw new RepositoryAlreadyExistsException("Repository with uniqueName " + options.getUniqueName() + " already exists.");
                    }
                    if (errorResponse.startsWith("Error code 001")) {
                        log.info((Object)("Could not create repository with uniqueName " + options.getUniqueName() + "as repository quota is exceeded. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                        throw new RepositoryQuotaExceededException("Repository quota exceeded.");
                    }
                    log.error((Object)("Could not create repository with uniqueName " + options.getUniqueName() + ". Unparsed error. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                    throw new ServiceException("Could not create repository with uniqueName " + options.getUniqueName());
                }
                log.error((Object)("Could not create repository, document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                throw new ServiceException("Could not create repository. Document Service responded with http " + httpStatusCode + " and error: " + errorResponse + " (see the logs for details)");
            }
            String result = EcmFactory.convertToStringAndClose(connection.getInputStream());
            try {
                JSONObject jsonResult = EcmFactory.parseJsonResponse(result);
                String repoId = (String)jsonResult.get((Object)JSON_REPO_ID);
                log.info((Object)("Created new repository with name '" + uniqueRepositoryName + "' with isolation '" + visibility.name() + "' and id '" + repoId + "'."));
                String string = repoId;
                return string;
            }
            catch (Exception e) {
                try {
                    log.error((Object)("Could not parse response to json: " + result), (Throwable)e);
                    throw new ServiceException("Could not create repository. Got this response from document service: " + result, e);
                }
                catch (IOException e2) {
                    throw new ServiceException("Cannot process request to Document Service to create a new repository (see contained exception)", e2);
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static void deleteRepository(String uniqueName, String repositoryKey) throws ServiceException, CmisObjectNotFoundException, RepositoryNotEmptyException {
        EcmFactory.deleteRepository(uniqueName, repositoryKey, null);
    }

    public static void deleteRepository(String uniqueName, String repositoryKey, String destination) throws ServiceException, CmisObjectNotFoundException, RepositoryNotEmptyException {
        SessionLookup sessionLookup = new SessionLookup(destination, null, null);
        String repositoryUrl = EcmFactory.computeRepositoryUrl(sessionLookup, uniqueName);
        EcmFactory.deleteRepositoryInternal(uniqueName, repositoryKey, destination, repositoryUrl, null);
    }

    public static void forceDeleteRepository(String uniqueName, String repositoryKey) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup lookup = new SessionLookup();
        String repositoryUrl = EcmFactory.computeForceDeleteUrl(lookup, uniqueName);
        EcmFactory.deleteRepositoryInternal(uniqueName, repositoryKey, null, repositoryUrl, null);
    }

    public static void forceDeleteRepositoryForTenant(String uniqueName, String repositoryKey, String tenantId) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup lookup = new SessionLookup(null, tenantId, null);
        String repositoryUrl = EcmFactory.computeForceDeleteUrl(lookup, uniqueName);
        EcmFactory.deleteRepositoryInternal(uniqueName, repositoryKey, null, repositoryUrl, tenantId);
    }

    public static void forceDeleteRepositoryForAllTenants(String uniqueName, String repositoryKey) throws ServiceException, CmisObjectNotFoundException {
        SessionLookup lookup = new SessionLookup();
        String repositoryUrl = EcmFactory.computeFullForceDeleteUrl(lookup, uniqueName);
        EcmFactory.deleteRepositoryInternal(uniqueName, repositoryKey, null, repositoryUrl, null);
    }

    private static void deleteRepositoryInternal(String uniqueName, String repositoryKey, String destination, String repositoryUrl, String tenantId) throws ServiceException, CmisObjectNotFoundException, RepositoryNotEmptyException {
        if (uniqueName == null || uniqueName.length() <= 0) {
            throw new CmisInvalidArgumentException("Repository UniqueName mising.");
        }
        if (repositoryKey == null || repositoryKey.length() <= 0) {
            throw new CmisInvalidArgumentException("Repository Key mising.");
        }
        HttpURLConnection connection = null;
        try {
            try {
                ClientCertificate clientCert;
                SSLSocketFactory sf;
                URL url = new URL(repositoryUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestMethod("DELETE");
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(60000);
                connection.addRequestProperty("X-EcmRepKeyEnc", repositoryKey);
                if (tenantId != null) {
                    connection.addRequestProperty("SAP-Tenant-Id", tenantId);
                }
                if (connection instanceof HttpsURLConnection && (sf = (clientCert = new ClientCertificate()).getSSLSocketFactory()) != null) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(sf);
                }
                connection.connect();
                int httpStatusCode = connection.getResponseCode();
                if (httpStatusCode != 200) {
                    String errorResponse = EcmFactory.convertToStringAndClose(connection.getErrorStream());
                    if (httpStatusCode == 404) {
                        log.info((Object)("Could not delete repository with uniqueName " + uniqueName + "as it does not exist. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                        throw new CmisObjectNotFoundException("Repository with uniqueName " + uniqueName + " does not exist.");
                    }
                    if (httpStatusCode == 403) {
                        if (errorResponse.startsWith("Error code 003")) {
                            log.info((Object)("Could not delete repository with uniqueName " + uniqueName + "as it still contains content. Document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                            throw new RepositoryNotEmptyException("Repository with uniqueName " + uniqueName + " is not empty.");
                        }
                        log.error((Object)("Could not delete repository, document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                        throw new ServiceException("Could not delete. Document Service responded with http " + httpStatusCode + "(see the logs for details)");
                    }
                    log.error((Object)("Could not delete repository, document service responded with http " + httpStatusCode + " and error: " + errorResponse));
                    throw new ServiceException("Could not delete repository. Document Service responded with http " + httpStatusCode + "(see the logs for details)");
                }
                String result = EcmFactory.convertToStringAndClose(connection.getInputStream());
                log.info((Object)("Deleted repository with name '" + uniqueName + " Response: " + result));
            }
            catch (IOException e) {
                throw new ServiceException("Cannot process request to Document Service to delete a repository (see contained exception)", e);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static String buildJsonRequest(RepositoryOptions options) {
        JSONObject json = new JSONObject();
        json.put((Object)JSON_APPLICATION_ID, (Object)EcmFactory.getAppId(null));
        json.put((Object)JSON_REPO_VISIBILITY, (Object)options.getVisibility().name().toLowerCase(Locale.ENGLISH));
        json.put((Object)JSON_REPO_MULTITENANT_CAPABLE, (Object)Boolean.toString(options.isMultiTenantCapable()));
        json.put((Object)JSON_REPO_VIRUS_SCANNING, (Object)Boolean.toString(options.isVirusScannerEnabled()));
        if (options.getDisplayName() != null) {
            json.put((Object)JSON_REPO_DISPLAY_NAME, (Object)options.getDisplayName());
        }
        if (options.getDescription() != null) {
            json.put((Object)JSON_REPO_DESCRIPTION, (Object)options.getDescription());
        }
        if (options.getRepositoryKey() != null) {
            json.put((Object)JSON_REPO_KEY, (Object)options.getRepositoryKey());
        }
        return json.toJSONString();
    }

    private static JSONObject parseJsonResponse(String response) throws ParseException {
        JSONParser parser = new JSONParser();
        JSONObject json = (JSONObject)parser.parse(response);
        return json;
    }

    private static String computeRepositoryUrl(SessionLookup lookup, String uniqueRepositoryName) {
        String ecmServerUrl = lookup.getEcmServerUrl();
        int i = ecmServerUrl.indexOf("/", "https://".length());
        if (i == -1) {
            i = ecmServerUrl.length();
        }
        if ((i = ecmServerUrl.indexOf("/", i + 1)) == -1) {
            i = ecmServerUrl.length();
        }
        return String.valueOf(ecmServerUrl.substring(0, i)) + "/repo/" + uniqueRepositoryName;
    }

    private static Session connectInternal(String repositoryId, String uniqueName, String repKey, SessionLookup sl, String user, List<String> additionalPrincipals, Map<String, String> sessionParams) {
        sessionParams = new HashMap<String, String>(sessionParams);
        int maxRetries = EcmFactory.getAndRemoveMaxRetries(sessionParams);
        long sleepDuration = EcmFactory.getAndRemoveSleepDuration(sessionParams);
        int i = 0;
        while (i <= maxRetries) {
            HashMap<String, String> tmpSessionParams = new HashMap<String, String>(sessionParams);
            try {
                return EcmFactory.connectInternalOnce(repositoryId, uniqueName, repKey, sl, user, additionalPrincipals, tmpSessionParams);
            }
            catch (CmisObjectNotFoundException e) {
                throw e;
            }
            catch (CmisConnectionException e) {
                if (i == maxRetries) {
                    log.error((Object)("last retry failed: " + i), (Throwable)e);
                    throw e;
                }
                log.error((Object)("intermediate try failed: " + i), (Throwable)e);
                EcmFactory.sleep(sleepDuration);
            }
            catch (RuntimeException e) {
                log.error((Object)e);
                throw e;
            }
            ++i;
        }
        CmisRuntimeException e = new CmisRuntimeException("should not happen");
        log.error((Object)e.getMessage(), (Throwable)e);
        throw e;
    }

    private static void sleep(long time) {
        if (time > 0L) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                throw new CmisRuntimeException("interrupted", (Throwable)e);
            }
        }
    }

    private static long getAndRemoveSleepDuration(Map<String, String> sessionParams) {
        long sleepDuration = 1000L;
        String sleepDurationString = sessionParams.remove(SLEEP_DURATION);
        if (sleepDurationString != null) {
            try {
                long tmpSleepDuration = new Long(sleepDurationString);
                if (tmpSleepDuration < 0L) {
                    log.warn((Object)("sleepDuration is negative: " + sleepDuration));
                } else {
                    sleepDuration = tmpSleepDuration;
                }
            }
            catch (RuntimeException e) {
                log.warn((Object)("sleepDuration is not an integer: " + sleepDurationString), (Throwable)e);
            }
        }
        return sleepDuration;
    }

    private static int getAndRemoveMaxRetries(Map<String, String> sessionParams) {
        int maxRetries = 2;
        String maxRetryString = sessionParams.remove(MAX_RETRIES);
        if (maxRetryString != null) {
            try {
                int tmpMaxRetries = new Integer(maxRetryString);
                if (tmpMaxRetries < 0) {
                    log.warn((Object)("maxRetries is negative: " + maxRetryString));
                } else {
                    maxRetries = tmpMaxRetries;
                }
            }
            catch (RuntimeException e) {
                log.warn((Object)("maxRetries is not an integer: " + maxRetryString), (Throwable)e);
            }
        }
        return maxRetries;
    }

    private static Session connectInternalOnce(String repositoryId, String uniqueName, String repKey, SessionLookup sl, String user, List<String> additionalPrincipals, Map<String, String> sessionParams) {
        SessionFactory sessionFactory;
        List repositories;
        int size;
        if (!sessionParams.containsKey("org.apache.chemistry.opencmis.session.repository.id")) {
            sessionParams.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
        }
        if (repKey != null && !sessionParams.containsKey("X-EcmRepKeyEnc")) {
            sessionParams.put("X-EcmRepKeyEnc", repKey);
        }
        if (!sessionParams.containsKey("X-EcmRepUniqueNameEnc")) {
            if (repositoryId.startsWith(REPID_PREFIX_FOR_UNIQENAME)) {
                sessionParams.put("X-EcmRepUniqueNameEnc", repositoryId.substring(1, repositoryId.length()));
            } else {
                sessionParams.put("X-EcmRepUniqueNameEnc", uniqueName);
            }
        }
        if (!sessionParams.containsKey("X-EcmUserEnc")) {
            if (user != null) {
                sessionParams.put("X-EcmUserEnc", user);
            } else {
                user = sl.getUser();
                if (user != null) {
                    sessionParams.put("X-EcmUserEnc", user);
                }
            }
        }
        if (sl.getTenantId() != null && !sessionParams.containsKey("SAP-Tenant-Id")) {
            sessionParams.put("SAP-Tenant-Id", sl.getTenantId());
        }
        if (!sessionParams.containsKey("X-EcmAddPrincipals") && additionalPrincipals != null && !additionalPrincipals.isEmpty()) {
            String encodeList = EcmFactory.encodeList(additionalPrincipals);
            sessionParams.put("X-EcmAddPrincipals", encodeList);
        }
        if ((size = (repositories = (sessionFactory = SessionLookup.getOpenCmisSessionFactory()).getRepositories(sessionParams)).size()) != 1) {
            String message = "Unexpected amount of repositories received. Should be 1 but got " + size;
            log.error((Object)message);
            if (size == 0) {
                throw new CmisObjectNotFoundException(message);
            }
            throw new CmisRuntimeException(message);
        }
        return ((Repository)repositories.get(0)).createSession();
    }

    private static Map<String, String> buildSessionParams(SessionLookup sessionLookup) {
        HashMap<String, String> sessionParams = new HashMap<String, String>();
        sessionParams.put("org.apache.chemistry.opencmis.binding.cookies", "true");
        sessionParams.put("org.apache.chemistry.opencmis.binding.auth.classname", EcmAuthenticationProvider.class.getName());
        if (sessionLookup.getEcmServerUrl().endsWith("/json") || sessionLookup.getEcmServerUrl().endsWith("/json/")) {
            sessionParams.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.BROWSER.value());
            sessionParams.put("org.apache.chemistry.opencmis.binding.browser.url", sessionLookup.getEcmServerUrl());
        } else {
            sessionParams.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            sessionParams.put("org.apache.chemistry.opencmis.binding.atompub.url", sessionLookup.getEcmServerUrl());
        }
        return sessionParams;
    }

    private static String getAppId(String applianceTriple) {
        String tripleInfo = applianceTriple;
        if (tripleInfo == null || tripleInfo.length() == 0) {
            tripleInfo = System.getProperty(SYSTEM_PROPERTY_ECM_APP_UNIQUE_NAME);
        }
        if (tripleInfo == null || tripleInfo.length() == 0) {
            tripleInfo = EcmFactory.getSystemTripleInformationInCloud();
        }
        if (tripleInfo == null || tripleInfo.length() == 0) {
            tripleInfo = "local_space;local_app;local_comp";
        }
        return tripleInfo;
    }

    private static String getSystemTripleInformationInCloud() {
        Properties p = new Properties();
        String path = null;
        try {
            p.load(new FileInputStream("space.properties"));
            path = String.valueOf(p.getProperty("jpSpace")) + ";" + p.getProperty("jpApp") + ";" + p.getProperty("component");
        }
        catch (FileNotFoundException e) {
            log.info((Object)"Could not load triple info from space.properties (not found).", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Could not load triple info from space.properties", (Throwable)e);
        }
        return path;
    }

    private static String convertToStringAndClose(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder writer = new StringBuilder();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                while ((n = reader.read(buffer)) != -1) {
                    writer.append(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return writer.toString();
        }
        return null;
    }

    private static String urlEncode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException("UTF-8 is an unknown encoding...", e);
        }
    }

    private static String encodeList(List<String> propList) {
        if (propList == null || propList.size() == 0) {
            throw new CmisInvalidArgumentException();
        }
        StringBuffer buffer = new StringBuffer();
        for (String nextProp : propList) {
            String encode = EcmFactory.encode(nextProp);
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(encode);
        }
        return buffer.toString();
    }

    private static String encode(String input) {
        if (input == null || input.length() == 0) {
            throw new CmisInvalidArgumentException();
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char next = input.charAt(i);
            if (next == '+') {
                result.append('+');
                result.append('+');
            } else if (next == ' ') {
                result.append('+');
                result.append('&');
            } else {
                result.append(next);
            }
            ++i;
        }
        return result.toString();
    }

    private static String computeFullForceDeleteUrl(SessionLookup lookup, String uniqueRepositoryName) {
        String repositoryUrl = EcmFactory.computeRepositoryUrl(lookup, uniqueRepositoryName);
        repositoryUrl = String.valueOf(repositoryUrl) + "/force" + "/full";
        return repositoryUrl;
    }

    private static String computeForceDeleteUrl(SessionLookup lookup, String uniqueRepositoryName) {
        String repositoryUrl = EcmFactory.computeRepositoryUrl(lookup, uniqueRepositoryName);
        repositoryUrl = String.valueOf(repositoryUrl) + "/force";
        return repositoryUrl;
    }
}

