/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ecm.api;

import com.sap.ecm.api.auth.EcmAuthenticationProvider;
import com.sap.ecm.api.internal.ServiceException;
import com.sap.ecm.api.internal.SessionLookup;
import com.sap.ecm.api.internal.cert.ClientCertificate;
import com.sap.security.auth.login.LoginContextFactory;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;

public abstract class AbstractCmisProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String uuid = UUID.randomUUID().toString();
    private static final String NO_UNIQUE_REPO_NAME = "null_" + uuid;
    private static final Logger LOG = Logger.getLogger(AbstractCmisProxyServlet.class);
    private static final String HTTPHEADER_X_ECMREPUNIQUENAME = "X-EcmRepUniqueNameEnc";
    private static final String HTTPHEADER_X_ECMREPKEY = "X-EcmRepKeyEnc";
    private static final String HTTPHEADER_X_CMIS_BASE_URL = "X-CmisBaseUrl";
    private static final String HTTPHEADER_X_ECM_USER = "X-EcmUserEnc";
    private static final List<String> NO_FORWARD_HEADERS = new ArrayList<String>(Arrays.asList("host", "cookie", "authorization", "connection", "keep-alive"));
    private static final String SESSION_ECM_COOKIES = "com.sap.ecm.api.ecm.cookies";
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private static final int BUFFER_SIZE = 4096;
    private SSLSocketFactory sslSocketFactory;
    private static Map<String, String> repoNameUrlMap = new HashMap<String, String>();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.sslSocketFactory = new ClientCertificate().getSSLSocketFactory();
        AbstractCmisProxyServlet.logInfoOrDebugWithStacktrace("Successfully initialised AbstractCmisProxyServlet");
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AbstractCmisProxyServlet.logInfoOrDebugWithStacktrace("service method called");
        String method = request.getMethod();
        LOG.debug((Object)("http method=" + method));
        if (!this.checkMethod(method)) {
            response.sendError(400);
            return;
        }
        String path = this.extractPath(request);
        LOG.debug((Object)("path=" + path));
        if (!this.checkPath(path)) {
            response.sendError(404);
            return;
        }
        if (this.readOnlyMode() && !method.equals("GET")) {
            LOG.info((Object)"enforcing read-only");
            response.setStatus(405);
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            PrintWriter pw = response.getWriter();
            pw.println("{\"exception\": \"notSupported\", \"message\": \"Only read operations are supported!\"}");
            return;
        }
        String url = null;
        try {
            String repositoryUniqueName = this.getAndCheckRepoName();
            String repositoryKey = this.getAndCheckRepoKey(repositoryUniqueName);
            HttpSession session = request.getSession();
            String query = request.getQueryString();
            LOG.debug((Object)("query=" + query));
            String reqHost = request.getServerName();
            LOG.debug((Object)("reqHost=" + reqHost));
            String ecmBaseUrl = this.findEcmUrl(repositoryUniqueName, repositoryKey, reqHost);
            LOG.debug((Object)("ecmBaseUrl=" + ecmBaseUrl));
            url = ecmBaseUrl + path + (String)(query != null ? "?" + query : "");
            LOG.info((Object)("Forwarding request to url=" + url));
            String user = null;
            boolean isWsdlRequest = this.isWebServicesWsdl(method, path);
            if (!isWsdlRequest && this.requireAuthentication()) {
                try {
                    user = this.authenticate(request, response);
                }
                catch (LoginException le) {
                    LOG.info((Object)("Login error. URL: " + url), (Throwable)le);
                    return;
                }
                catch (Exception e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Authentication error. URL: " + url), (Throwable)e);
                    }
                    this.sendCMISProxyError(request, response, "CMIS Proxy login error.");
                    return;
                }
            }
            URL oldURL = new URL(url);
            HttpURLConnection conn = this.getConnection(request.getMethod(), oldURL);
            this.setRequestHeader(request, conn);
            this.addNameAndKeyHeader(conn, repositoryUniqueName, repositoryKey);
            conn.setRequestProperty(HTTPHEADER_X_CMIS_BASE_URL, EcmAuthenticationProvider.encodeUTF8((String)this.getProxyBaseUrl(request)));
            if (user != null && !user.isEmpty()) {
                conn.setRequestProperty(HTTPHEADER_X_ECM_USER, EcmAuthenticationProvider.encodeUTF8((String)user));
            }
            this.setCookies(session, conn);
            this.forwardRequestStream(request, conn);
            LOG.debug((Object)"forwarding now...");
            conn.connect();
            int responseCode = conn.getResponseCode();
            LOG.debug((Object)("got responseCode=" + responseCode + " from ecm, will forward it back"));
            response.setStatus(responseCode);
            URL newUrl = conn.getURL();
            LOG.debug((Object)("newUrl=" + newUrl));
            if (repositoryUniqueName != null && responseCode == 200 && !oldURL.getHost().equals(newUrl.getHost())) {
                URL ecmBaseUrlAsURL = new URL(ecmBaseUrl);
                URL newEcmBaseUrl = new URL(ecmBaseUrlAsURL.getProtocol(), newUrl.getHost(), ecmBaseUrlAsURL.getPort(), ecmBaseUrlAsURL.getFile());
                this.setBaseUrlToCache(repositoryUniqueName, reqHost, newEcmBaseUrl.toExternalForm());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("followed redirect, oldEcmBaseUrl=" + ecmBaseUrl + ", new=" + newEcmBaseUrl.toExternalForm()));
                }
            }
            List<String> cookies = this.copyResponseHeaderAndGetCookies(response, conn);
            this.storeCookiesInSession(session, cookies);
            LOG.debug((Object)"backwarding now...");
            this.forwardResponseStream(response, conn);
        }
        catch (SocketTimeoutException ste) {
            LOG.error((Object)("Timeout while reading or writing bytes (check stacktrace to see whether it was read or write; ecm server url is " + url + ")"), (Throwable)ste);
            this.sendCMISProxyError(request, response, "CMIS Proxy timeout during read or write.");
        }
        catch (Exception e) {
            LOG.error((Object)("Communication error during reading or writing bytes (check stacktrace to see whether it was read or write; ecm server url is " + url + ")"), (Throwable)e);
            this.sendCMISProxyError(request, response, "CMIS Proxy communication error during read or write.");
        }
    }

    private void addNameAndKeyHeader(HttpURLConnection conn, String repositoryUniqueName, String repositoryKey) {
        if (repositoryUniqueName != null) {
            conn.setRequestProperty(HTTPHEADER_X_ECMREPUNIQUENAME, EcmAuthenticationProvider.encodeUTF8((String)repositoryUniqueName));
            conn.setRequestProperty(HTTPHEADER_X_ECMREPKEY, EcmAuthenticationProvider.encodeUTF8((String)repositoryKey));
        }
    }

    private void forwardResponseStream(HttpServletResponse response, HttpURLConnection conn) throws IOException {
        if (conn.getContentLength() != 0) {
            InputStream stream = conn.getErrorStream();
            if (stream == null) {
                stream = conn.getInputStream();
            }
            if (stream != null) {
                ServletOutputStream out = response.getOutputStream();
                this.copyStream(stream, (OutputStream)out, false);
                stream.close();
                out.flush();
            }
        }
    }

    private void storeCookiesInSession(HttpSession session, List<String> cookies) {
        if (!cookies.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String cookie : cookies) {
                int x;
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                if ((x = cookie.indexOf(59)) >= 0) {
                    sb.append(cookie.substring(0, x).trim());
                    continue;
                }
                sb.append(cookie.trim());
            }
            session.setAttribute(SESSION_ECM_COOKIES, (Object)sb.toString());
        }
    }

    private List<String> copyResponseHeaderAndGetCookies(HttpServletResponse response, HttpURLConnection targetConnection) {
        ArrayList<String> cookies = new ArrayList<String>();
        for (Map.Entry<String, List<String>> header : targetConnection.getHeaderFields().entrySet()) {
            String lowerHeaderName;
            if (header.getKey() == null || (lowerHeaderName = header.getKey().toLowerCase(Locale.ENGLISH)).equals("transfer-encoding") || lowerHeaderName.equals("connection") || lowerHeaderName.equals("content-length") || lowerHeaderName.equals("via")) continue;
            for (String value : header.getValue()) {
                if (lowerHeaderName.equals("set-cookie")) {
                    cookies.add(value);
                    continue;
                }
                response.addHeader(header.getKey(), value);
            }
        }
        return cookies;
    }

    private void forwardRequestStream(HttpServletRequest sourceRequest, HttpURLConnection targetConnection) throws IOException {
        if (this.mayHaveContent(sourceRequest)) {
            targetConnection.setDoOutput(true);
            targetConnection.setChunkedStreamingMode(65535);
            OutputStream out = targetConnection.getOutputStream();
            this.copyStream((InputStream)sourceRequest.getInputStream(), out, AbstractCmisProxyServlet.isFormUrlencodedContent(sourceRequest));
            out.flush();
        } else {
            targetConnection.setDoOutput(false);
        }
    }

    private void setCookies(HttpSession session, HttpURLConnection targetConnection) {
        String cookieStr = (String)session.getAttribute(SESSION_ECM_COOKIES);
        if (cookieStr != null && !cookieStr.isEmpty()) {
            targetConnection.setRequestProperty("Cookie", cookieStr);
        }
    }

    private String getAndCheckRepoKey(String repositoryUniqueName) {
        String repositoryKey = this.getRepositoryKey();
        if (!this.checkNameOrKey(repositoryKey)) {
            throw new ServiceException("Invalid repository key!");
        }
        if (repositoryUniqueName != null && repositoryKey == null) {
            throw new ServiceException("Repository key not set!");
        }
        return repositoryKey;
    }

    private String getAndCheckRepoName() {
        String repositoryUniqueName = this.getRepositoryUniqueName();
        if (!this.checkNameOrKey(repositoryUniqueName)) {
            throw new ServiceException("Invalid repository unique name!");
        }
        return repositoryUniqueName;
    }

    private void setRequestHeader(HttpServletRequest sourceRequest, HttpURLConnection targetConnection) {
        Enumeration headerNames = sourceRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            LOG.debug((Object)("checking headerName=" + headerName));
            if (this.isHeaderAllowedToForward(headerName)) {
                LOG.debug((Object)"forwarding header as it is allowed");
                Enumeration values = sourceRequest.getHeaders(headerName);
                while (values.hasMoreElements()) {
                    targetConnection.addRequestProperty(headerName, (String)values.nextElement());
                }
                continue;
            }
            LOG.debug((Object)"won't forward this header, not allowed");
        }
    }

    private HttpURLConnection getConnection(String method, URL url) throws IOException, ProtocolException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setAllowUserInteraction(false);
        conn.setUseCaches(false);
        conn.setConnectTimeout(this.getConnectTimeout());
        conn.setReadTimeout(this.getReadTimeout());
        if (conn instanceof HttpsURLConnection && this.sslSocketFactory != null) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBaseUrlFromCache(String repositoryUniqueName, String reqHost) {
        String key = this.generateCacheKey(repositoryUniqueName, reqHost);
        Map<String, String> map = repoNameUrlMap;
        synchronized (map) {
            String cachedEntry = repoNameUrlMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cache lookup with key=" + key + " and result=" + cachedEntry));
            }
            return cachedEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBaseUrlToCache(String repositoryUniqueName, String reqHost, String ecmBaseUrl) {
        String key = this.generateCacheKey(repositoryUniqueName, reqHost);
        Map<String, String> map = repoNameUrlMap;
        synchronized (map) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cache insert with key=" + key + " and ecmBaseUrl=" + ecmBaseUrl));
            }
            repoNameUrlMap.put(key, ecmBaseUrl);
        }
    }

    private String generateCacheKey(String repositoryUniqueName, String reqHost) {
        if (repositoryUniqueName == null) {
            repositoryUniqueName = NO_UNIQUE_REPO_NAME;
        }
        return repositoryUniqueName + "," + reqHost;
    }

    private boolean isHeaderAllowedToForward(String headerName) {
        if (headerName == null || headerName.length() == 0) {
            return false;
        }
        String lowerHeaderName = headerName.toLowerCase(Locale.ENGLISH);
        if ("X-EcmAddPrincipals".toLowerCase(Locale.ENGLISH).equals(lowerHeaderName)) {
            return true;
        }
        if (lowerHeaderName.startsWith("x-") || lowerHeaderName.startsWith("sap-")) {
            return false;
        }
        return !NO_FORWARD_HEADERS.contains(lowerHeaderName);
    }

    protected String getDestinationName() {
        return null;
    }

    protected abstract String getRepositoryUniqueName();

    protected abstract String getRepositoryKey();

    protected boolean supportWebServicesBinding() {
        return true;
    }

    protected boolean supportAtomPubBinding() {
        return true;
    }

    protected boolean supportBrowserBinding() {
        return true;
    }

    protected boolean supportCMIS_1_0() {
        return true;
    }

    protected boolean supportCMIS_1_1() {
        return true;
    }

    protected boolean requireAuthentication() {
        return true;
    }

    protected String authenticate(HttpServletRequest request, HttpServletResponse response) throws LoginException {
        String user = request.getRemoteUser();
        if (user == null) {
            LoginContext loginContext = LoginContextFactory.createLoginContext("BASIC");
            loginContext.login();
            user = request.getRemoteUser();
        }
        return user;
    }

    protected boolean readOnlyMode() {
        return false;
    }

    protected int getConnectTimeout() {
        return 30000;
    }

    protected int getReadTimeout() {
        return 300000;
    }

    private void copyStream(InputStream in, OutputStream out, boolean failOnEmptyInputStream) throws IOException {
        boolean streamIsEmpty = true;
        byte[] buffer = new byte[4096];
        int b = 0;
        while ((b = in.read(buffer)) > -1) {
            out.write(buffer, 0, b);
            if (!streamIsEmpty || b <= 0) continue;
            streamIsEmpty = false;
        }
        if (failOnEmptyInputStream && streamIsEmpty) {
            LOG.error((Object)"The body of the request was empty, although this is not allowed in this case. Maybe you consumed the body by accident? In any case, this request will fail on the document service ...");
        }
    }

    private boolean mayHaveContent(HttpServletRequest request) {
        return request.getMethod().equals("POST") || request.getMethod().equals("PUT");
    }

    private String extractPath(HttpServletRequest request) {
        int prefixLength = request.getContextPath().length() + request.getServletPath().length();
        return request.getRequestURI().substring(prefixLength);
    }

    private String getProxyBaseUrl(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getScheme());
        sb.append("://");
        sb.append(request.getServerName());
        sb.append(':');
        sb.append(request.getServerPort());
        sb.append(request.getContextPath());
        sb.append(request.getServletPath());
        return sb.toString();
    }

    private boolean isAtomBinding(String path) {
        return path != null && (this.supportCMIS_1_0() && (path.equals("/atom") || path.startsWith("/atom/")) || this.supportCMIS_1_1() && (path.equals("/1.1/atom") || path.startsWith("/1.1/atom/")));
    }

    private boolean isBrowserBinding(String path) {
        return path != null && (this.supportCMIS_1_0() && (path.equals("/json") || path.startsWith("/json/")) || this.supportCMIS_1_1() && (path.equals("/1.1/json") || path.startsWith("/1.1/json/")));
    }

    private boolean isWebServicesBinding(String path) {
        return path != null && (this.supportCMIS_1_0() && path.startsWith("/services/") || this.supportCMIS_1_1() && path.startsWith("/1.1/services/"));
    }

    private boolean isWebServicesWsdl(String method, String path) {
        return "GET".equals(method) && this.isWebServicesBinding(path) && (path.endsWith("?wsdl") || path.endsWith("?core") || path.endsWith("?msg"));
    }

    private boolean checkPath(String path) {
        return this.supportAtomPubBinding() && !this.readOnlyMode() && this.isAtomBinding(path) || this.supportBrowserBinding() && this.isBrowserBinding(path) || this.supportWebServicesBinding() && !this.readOnlyMode() && this.isWebServicesBinding(path);
    }

    private boolean checkMethod(String method) {
        return method.equals("GET") || method.equals("POST") || method.equals("PUT") || method.equals("DELETE");
    }

    private void sendCMISProxyError(HttpServletRequest request, HttpServletResponse response, String message) throws IOException {
        response.setStatus(500);
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        String path = this.extractPath(request);
        if (this.isAtomBinding(path)) {
            response.setContentType("text/html; charset=utf-8");
            pw.print("<html><head><title>CMIS Proxy Error</title></head><body>");
            pw.print("<h1>HTTP Status 500 - <!--exception-->runtime<!--/exception--></h1>");
            pw.print("<p><!--message-->" + message + "<!--/message--></p>");
            pw.println("</body></html>");
        } else if (this.isBrowserBinding(path)) {
            response.setContentType("application/json; charset=utf-8");
            pw.println("{\"exception\": \"runtime\", \"message\": \"" + message + "\"}");
        } else if (this.isWebServicesBinding(path)) {
            if (request.getMethod().equals("GET")) {
                response.setContentType("text/plain; charset=utf-8");
                pw.println(message);
            } else {
                response.setContentType("text/xml; charset=utf-8");
                pw.println("<?xml version='1.0' encoding='UTF-8'?>");
                pw.println("<S:Envelope xmlns:S=\"http://schemas.xmlsoap.org/soap/envelope/\">");
                pw.println("<S:Body>");
                pw.println("<S:Fault>");
                pw.println("<faultcode>S:Server</faultcode>");
                pw.println("<faultstring>" + message + "</faultstring>");
                pw.println("<detail>");
                pw.println("<cmisFault xmlns=\"http://docs.oasis-open.org/ns/cmis/messaging/200908/\">");
                pw.println("<type>runtime</type>");
                pw.println("<code>0</code>");
                pw.println("<message>" + message + "</message>");
                pw.println("</cmisFault>");
                pw.println("</detail>");
                pw.println("</S:Fault>");
                pw.println("</S:Body>");
                pw.println("</S:Envelope>");
            }
        } else {
            response.setContentType("text/plain; charset=utf-8");
            pw.println(message);
        }
        pw.flush();
    }

    private boolean checkNameOrKey(String s) {
        if (s == null) {
            return true;
        }
        if (s.length() < 1 || s.length() > 1024) {
            return false;
        }
        return s.indexOf(10) <= -1 && s.indexOf(13) <= -1;
    }

    private String findEcmUrl(String repositoryUniqueName, String repositoryKey, String reqHost) throws ProtocolException, IOException {
        String ecmBaseUrl = this.getBaseUrlFromCache(repositoryUniqueName, reqHost);
        if (ecmBaseUrl != null) {
            LOG.debug((Object)"cache hit");
            return ecmBaseUrl;
        }
        LOG.debug((Object)"cache miss, asking SessionLookup");
        SessionLookup sessionLookup = new SessionLookup(this.getDestinationName(), null, null);
        ecmBaseUrl = sessionLookup.getEcmServerUrl().trim();
        if (ecmBaseUrl.endsWith("/")) {
            ecmBaseUrl = ecmBaseUrl.substring(0, ecmBaseUrl.length() - 2);
        }
        int x = ecmBaseUrl.lastIndexOf(47);
        ecmBaseUrl = ecmBaseUrl.substring(0, x);
        if (repositoryUniqueName == null) {
            this.setBaseUrlToCache(repositoryUniqueName, reqHost, ecmBaseUrl);
        } else {
            URL url = new URL(ecmBaseUrl + "/json");
            LOG.debug((Object)("check for redirect on url=" + url.toExternalForm()));
            HttpURLConnection conn = this.getConnection("GET", url);
            this.addNameAndKeyHeader(conn, repositoryUniqueName, repositoryKey);
            conn.connect();
            int responseCode = conn.getResponseCode();
            URL newUrl = conn.getURL();
            LOG.debug((Object)("newUrl=" + newUrl + " from responseCode=" + responseCode));
            if (responseCode == 200 && !url.getHost().equals(newUrl.getHost())) {
                URL ecmBaseUrlAsURL = new URL(ecmBaseUrl);
                URL newEcmBaseUrl = new URL(ecmBaseUrlAsURL.getProtocol(), newUrl.getHost(), ecmBaseUrlAsURL.getPort(), ecmBaseUrlAsURL.getFile());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("followed redirect, oldEcmBaseUrl=" + ecmBaseUrl + ", new=" + newEcmBaseUrl.toExternalForm()));
                }
                ecmBaseUrl = newEcmBaseUrl.toExternalForm();
            }
            if (responseCode == 200) {
                this.setBaseUrlToCache(repositoryUniqueName, reqHost, ecmBaseUrl);
            } else if (responseCode == 404) {
                LOG.warn((Object)("repository with unique name " + repositoryUniqueName + " not found"));
            } else {
                LOG.error((Object)("requesting repository with unique name " + repositoryUniqueName + " returned: " + responseCode));
            }
        }
        return ecmBaseUrl;
    }

    private static final boolean isFormUrlencodedContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("application/x-www-form-urlencoded");
    }

    private static void logInfoOrDebugWithStacktrace(String message) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)message, (Throwable)new Exception());
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)message);
        }
    }
}

