/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.log4j.Logger;

public class NeoInitializer {
    public void initJCoRuntime() throws JCoException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Logger.getLogger((String)"com.sap.conn.jco").debug((Object)"initialising JCoRuntime");
        Class<?> runtimeClass = null;
        try {
            runtimeClass = Class.forName("com.sap.conn.jco.rt.neo.NeoRuntimeFactory");
        }
        catch (ClassNotFoundException e) {
            throw new JCoException(136, "JCo runtime bundle is not available - missing NeoRuntimeFactory.", e);
        }
        try {
            Method getRuntime = runtimeClass.getMethod("getRuntime", new Class[0]);
            JCoInterface runtime = (JCoInterface)getRuntime.invoke(null, new Object[0]);
            JCo.setRuntime(runtime);
            Logger.getLogger((String)"com.sap.conn.jco").debug((Object)"finished initialization of JCoRuntime");
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof LinkageError) {
                this.processLoadError((Error)targetException);
            }
            throw e;
        }
    }

    private void processLoadError(Error e) {
        StringBuilder out = new StringBuilder();
        String lineEnd = System.getProperty("line.separator");
        out.append("Cannot load the JCo native library. (exception ").append(e.toString()).append(")").append(lineEnd);
        out.append("If you don't develop a JCo scenario for HANA Cloud, you can ignore this issue.").append(lineEnd);
        if (!this.is64BitPlatform()) {
            out.append("The Java VM running now is a 32bit variant.").append(lineEnd);
            out.append("Please use a 64bit JVM instead, if you want to develop JCo scenarios.").append(lineEnd);
        } else if (this.isWindowsPlatform()) {
            out.append("Check if you have installed the Visual Studio 2010 runtime libraries in the correct version. (vcredist.msi)").append(lineEnd);
            out.append("The 64bit msi can be downloaded from http://www.microsoft.com/download/en/details.aspx?id=14632");
            out.append(lineEnd);
        }
        Logger.getLogger((String)"com.sap.conn.jco").info((Object)out.toString());
        throw new RuntimeException(out.toString(), e);
    }

    private boolean isWindowsPlatform() {
        String osName = System.getProperty("os.name");
        String osNameLowerCase = osName.toLowerCase(Locale.ENGLISH);
        return osNameLowerCase.startsWith("windows");
    }

    private boolean is64BitPlatform() {
        String s = System.getProperty("sun.arch.data.model");
        if (s == null) {
            s = System.getProperty("os.arch");
        }
        return s.indexOf("64") > -1;
    }
}

