/*
 * Decompiled with CFR 0.152.
 */
package com.sap.core.connectivity.api.ldap;

import com.sap.cloud.runtime.impl.bridge.ClassloadingBridge;
import com.sap.core.connectivity.api.ldap.ConnectivitySocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.net.SocketFactory;

public class LdapOnPremiseSocketFactory
extends SocketFactory {
    private static ConnectivitySocketFactory connectivitySocketFactory;

    protected void setConnectivitySocketFactory(ConnectivitySocketFactory factory) {
        connectivitySocketFactory = factory;
    }

    public static SocketFactory getDefault() {
        return new LdapOnPremiseSocketFactory();
    }

    private static synchronized void initialize() {
        if (connectivitySocketFactory == null) {
            if (!LdapOnPremiseSocketFactory.isOSGi()) {
                connectivitySocketFactory = LdapOnPremiseSocketFactory.getConnectivitySocketFactoryAsJavaService();
            }
            if (connectivitySocketFactory == null) {
                throw new IllegalStateException("Default LDAP on premise factory is not initialized yet");
            }
        }
    }

    private static boolean isOSGi() {
        return System.getProperty("osgi.configuration.area") != null;
    }

    private static ConnectivitySocketFactory getConnectivitySocketFactoryAsJavaService() {
        ConnectivitySocketFactory result = null;
        ServiceLoader<ConnectivitySocketFactory> loader = ServiceLoader.load(ConnectivitySocketFactory.class, ClassloadingBridge.getImplClassLoader());
        Iterator<ConnectivitySocketFactory> iterator = loader.iterator();
        if (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        LdapOnPremiseSocketFactory.initialize();
        return connectivitySocketFactory.createConnectivitySocket(host, port);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        LdapOnPremiseSocketFactory.initialize();
        return connectivitySocketFactory.createConnectivitySocket(host, port);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        LdapOnPremiseSocketFactory.initialize();
        return connectivitySocketFactory.createConnectivitySocket(host.toString(), port);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        LdapOnPremiseSocketFactory.initialize();
        return connectivitySocketFactory.createConnectivitySocket(address.toString(), port);
    }
}

