/*
 * Decompiled with CFR 0.152.
 */
package com.sap.gateway.ip.core.customdev.processor;

import com.sap.gateway.ip.core.customdev.processor.SoapFaultParam;
import com.sap.gateway.ip.core.customdev.processor.UnknownFaultCodeException;
import com.sap.gateway.ip.core.customdev.processor.UnknownSoapVersionException;
import com.sap.gateway.ip.core.customdev.processor.XiSoapFaultParam;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

public class SoapFaultFactory {
    public static final String SOAP11_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP12_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";

    private SoapFaultFactory() {
    }

    public static void throwSoapFault(SoapFaultParam param) throws UnknownSoapVersionException, UnknownFaultCodeException {
        Logger logger = Logger.getLogger(SoapFaultFactory.class.getName());
        Fault fault = new Fault(param.getFaultstring(), logger);
        SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(param.getVersionNamespace());
        if (soapVersion == null) {
            throw new UnknownSoapVersionException(param.getVersionNamespace());
        }
        SoapFault soapFault = SoapFault.createFault((Fault)fault, (SoapVersion)soapVersion);
        if (soapVersion.getNamespace().equals(SOAP12_NAMESPACE)) {
            if (param.getFaultcode().equals(soapVersion.getReceiver()) || param.getFaultcode().equals(soapVersion.getSender()) || param.getFaultcode().equals(soapVersion.getMustUnderstand()) || param.getFaultcode().equals(soapVersion.getDateEncodingUnknown()) || param.getFaultcode().equals(soapVersion.getVersionMismatch())) {
                soapFault.setSubCodes(param.getSubcodes());
            } else {
                throw new UnknownFaultCodeException(param.getFaultcode());
            }
        }
        soapFault.setFaultCode(param.getFaultcode());
        soapFault.setRole(param.getFaultactor());
        soapFault.setDetail(param.getDetail());
        throw soapFault;
    }

    public static void throwSoapFault(String faultstring, Element detail, Map<String, String> namespaces) {
        if (namespaces == null) {
            namespaces = new HashMap<String, String>();
        }
        Logger logger = Logger.getLogger(SoapFaultFactory.class.getName());
        Fault fault = new Fault(faultstring, logger);
        Soap11 soapVersion = Soap11.getInstance();
        SoapFault soapFault = SoapFault.createFault((Fault)fault, (SoapVersion)soapVersion);
        soapFault.setDetail(detail);
        soapFault.setNamespaces(namespaces);
        throw soapFault;
    }

    public static void throwXiSoapFault(XiSoapFaultParam param) throws XMLStreamException {
        Soap11 soapVersion = Soap11.getInstance();
        Logger logger = Logger.getLogger(SoapFaultFactory.class.getName());
        Fault fault = new Fault(param.getFaultstring(), logger);
        SoapFault soapFault = SoapFault.createFault((Fault)fault, (SoapVersion)soapVersion);
        soapFault.setFaultCode(param.getFaultcode());
        soapFault.setRole(param.getFaultactor());
        String xml = "<a><SAP:Error soap:mustUnderstand=\"1\" xmlns:SAP=\"http://sap.com/xi/XI/Message/30\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><SAP:Category>XIServer</SAP:Category><SAP:Code area=\"INTERNAL\">MESSAGE</SAP:Code><SAP:P1>{0}</SAP:P1><SAP:P2>{1}</SAP:P2><SAP:P3>{2}</SAP:P3><SAP:P4>{3}</SAP:P4><SAP:AdditionalText>{4}</SAP:AdditionalText><SAP:Stack>{5}</SAP:Stack></SAP:Error></a>";
        Element detail = StaxUtils.read((Reader)new StringReader(MessageFormat.format(xml, param.getSapP1(), param.getSapP2(), param.getSapP3(), param.getSapP4(), param.getSapAdditionalText(), param.getSapStack()))).getDocumentElement();
        soapFault.setDetail(detail);
        throw soapFault;
    }
}

