/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import javax.annotation.Nullable;

public enum CredentialType {
    X509("x509"),
    INSTANCE_SECRET("instance-secret"),
    BINDING_SECRET("binding-secret");

    private final String typeName;

    private CredentialType(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return this.typeName;
    }

    @Nullable
    public static CredentialType from(String claimName) {
        for (CredentialType credentialType : CredentialType.values()) {
            if (!credentialType.typeName.equals(claimName)) continue;
            return credentialType;
        }
        return null;
    }
}

