/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.GrantType;
import com.sap.cloud.security.token.InvalidTokenException;
import com.sap.cloud.security.token.ProviderNotFoundException;
import com.sap.cloud.security.token.TokenFactory;
import java.io.Serializable;
import java.security.Principal;
import java.security.ProviderException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public interface Token
extends Serializable {
    public static final List<TokenFactory> services = new ArrayList(){
        {
            ServiceLoader.load(TokenFactory.class).forEach(this::add);
            LoggerFactory.getLogger(Token.class).info("loaded TokenFactory service providers: {}", (Object)this);
        }
    };
    public static final String DEFAULT_TOKEN_FACTORY = "com.sap.cloud.security.servlet.HybridTokenFactory";

    public static Token create(String jwt) {
        if (services.isEmpty()) {
            throw new ProviderNotFoundException("No TokenFactory implementation found in the classpath");
        }
        if (services.size() > 2) {
            throw new ProviderException("More than 1 Custom TokenFactory service provider found. There should be only one");
        }
        if (services.size() == 2) {
            return services.stream().filter(tokenFactory -> !tokenFactory.getClass().getName().equals(DEFAULT_TOKEN_FACTORY)).findFirst().get().create(jwt);
        }
        return services.get(0).create(jwt);
    }

    @Nullable
    public String getHeaderParameterAsString(@Nonnull String var1);

    public boolean hasHeaderParameter(@Nonnull String var1);

    public boolean hasClaim(@Nonnull String var1);

    @Nullable
    public String getClaimAsString(@Nonnull String var1);

    @Nonnull
    public List<String> getClaimAsStringList(@Nonnull String var1);

    @Nullable
    public JsonObject getClaimAsJsonObject(@Nonnull String var1);

    @Nullable
    public Instant getExpiration();

    public boolean isExpired();

    @Nullable
    public Instant getNotBefore();

    public String getTokenValue();

    public Principal getPrincipal();

    public Service getService();

    default public Set<String> getAudiences() {
        return new LinkedHashSet<String>(this.getClaimAsStringList("aud"));
    }

    public String getZoneId();

    default public String getClientId() {
        String clientId = this.getClaimAsString("azp");
        if (clientId == null || clientId.trim().isEmpty()) {
            Set<String> audiences = this.getAudiences();
            if (audiences.size() == 1) {
                return (String)audiences.stream().findFirst().get();
            }
            throw new InvalidTokenException("Couldn't get client id. Invalid authorized party or audience claims.");
        }
        return clientId;
    }

    default public String getIssuer() {
        return this.getClaimAsString("iss");
    }

    @Nullable
    default public GrantType getGrantType() {
        return GrantType.from(this.getClaimAsString("grant_type"));
    }

    default public Map<String, Object> getHeaders() {
        return Collections.emptyMap();
    }

    default public Map<String, Object> getClaims() {
        return Collections.emptyMap();
    }

    @Nullable
    default public String getAttributeFromClaimAsString(String claimName, String attributeName) {
        return Optional.ofNullable(this.getClaimAsJsonObject(claimName)).map(claim -> claim.getAsString(attributeName)).orElse(null);
    }

    @Nullable
    default public List<String> getAttributeFromClaimAsStringList(String claimName, String attributeName) {
        JsonObject claimAsJsonObject = this.getClaimAsJsonObject(claimName);
        return Optional.ofNullable(claimAsJsonObject).map(jsonObject -> jsonObject.getAsList(attributeName, String.class)).orElse(null);
    }
}

