/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.x509;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class X509Parser {
    public static final Logger LOGGER = LoggerFactory.getLogger(X509Parser.class);
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    private X509Parser() {
    }

    static X509Certificate parseCertificate(@Nonnull String encodedX509) throws CertificateException {
        String encodedPemX509 = X509Parser.formatBase64Cert(encodedX509);
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bytes = new ByteArrayInputStream(encodedPemX509.getBytes(StandardCharsets.UTF_8));
        return (X509Certificate)certFactory.generateCertificate(bytes);
    }

    static String getCertificateThumbprint(X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] hashedX509 = sha256.digest(x509Certificate.getEncoded());
        return Base64.getUrlEncoder().withoutPadding().encodeToString(hashedX509);
    }

    static String formatBase64Cert(@Nonnull String base64EncodedCert) {
        Objects.requireNonNull(base64EncodedCert, "The provided Certificate can not be null");
        String cert = base64EncodedCert.replace("\\n", "").replace(BEGIN_CERTIFICATE, "-----BEGIN CERTIFICATE-----\n").replace(END_CERTIFICATE, "\n-----END CERTIFICATE-----\n").replaceAll("\\n$", "");
        return X509Parser.encodePemLabels(cert);
    }

    @Nonnull
    private static String encodePemLabels(String base64EncodedCert) {
        if (!base64EncodedCert.startsWith(BEGIN_CERTIFICATE)) {
            base64EncodedCert = "-----BEGIN CERTIFICATE-----\n" + base64EncodedCert;
        }
        if (!base64EncodedCert.endsWith(END_CERTIFICATE)) {
            base64EncodedCert = base64EncodedCert + "\n" + END_CERTIFICATE;
        }
        LOGGER.debug("PEM encoded certificate: {}", (Object)base64EncodedCert);
        return base64EncodedCert;
    }
}

