/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Service {
    XSUAA("xsuaa"),
    IAS(Service.getIasServiceName());

    private final String cloudFoundryName;

    private static String getIasServiceName() {
        Logger logger = LoggerFactory.getLogger(Service.class);
        if (System.getenv("IAS_SERVICE_NAME") != null) {
            logger.warn("As of version 2.8.0 IAS_SERVICE_NAME system environment variable is no longer needed. Service 'identity' is available with plan 'application'.");
        }
        return "identity";
    }

    private Service(String cloudFoundryName) {
        this.cloudFoundryName = cloudFoundryName;
    }

    public String getCFName() {
        return this.cloudFoundryName;
    }
}

