/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.token.AccessToken;
import com.sap.cloud.security.token.IdTokenExtension;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.XsuaaTokenExtension;
import com.sap.cloud.security.x509.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContext.class);
    private static final ThreadLocal<SecurityContext> contextStorage = ThreadLocal.withInitial(SecurityContext::new);
    Token token;
    Token idToken;
    Token xsuaaToken;
    Token initialToken;
    Certificate certificate;
    List<String> servicePlans;
    private static IdTokenExtension idTokenExtension;
    private static XsuaaTokenExtension xsuaaTokenExtension;

    SecurityContext() {
    }

    private static SecurityContext get() {
        return contextStorage.get();
    }

    @Nullable
    public static Token getToken() {
        return SecurityContext.get().token;
    }

    public static void setToken(Token token) {
        SecurityContext ctx = SecurityContext.get();
        ctx.token = token;
        ctx.initialToken = token;
        ctx.idToken = null;
        ctx.xsuaaToken = null;
    }

    public static void updateToken(Token token) {
        SecurityContext ctx = SecurityContext.get();
        ctx.token = token;
    }

    @Nullable
    public static Token getInitialToken() {
        return SecurityContext.get().initialToken;
    }

    @Nullable
    public static AccessToken getAccessToken() {
        Token token = SecurityContext.get().token;
        return token instanceof AccessToken ? (AccessToken)token : null;
    }

    public static void clearToken() {
        SecurityContext ctx = SecurityContext.get();
        if (ctx.token != null) {
            LOGGER.debug("Token of service {} removed from SecurityContext (thread-locally).", (Object)ctx.token.getService());
            ctx.token = null;
        }
    }

    private static void clearInitialToken() {
        SecurityContext ctx = SecurityContext.get();
        if (ctx.initialToken != null) {
            LOGGER.debug("Initial token of service {} removed from SecurityContext (thread-locally).", (Object)ctx.initialToken.getService());
            ctx.initialToken = null;
        }
    }

    @Nullable
    public static Token getIdToken() {
        SecurityContext ctx = SecurityContext.get();
        if (idTokenExtension != null) {
            ctx.idToken = idTokenExtension.resolveIdToken(ctx.idToken);
        }
        return ctx.idToken;
    }

    private static void clearIdToken() {
        SecurityContext ctx = SecurityContext.get();
        if (ctx.idToken != null) {
            LOGGER.debug("ID token removed from SecurityContext (thread-locally).");
            ctx.idToken = null;
        }
    }

    public static void setXsuaaToken(Token token) {
        SecurityContext ctx = SecurityContext.get();
        ctx.xsuaaToken = token;
    }

    @Nullable
    public static Token getXsuaaToken() {
        SecurityContext ctx = SecurityContext.get();
        if (xsuaaTokenExtension != null) {
            ctx.xsuaaToken = xsuaaTokenExtension.resolveXsuaaToken(ctx.xsuaaToken);
        }
        return ctx.xsuaaToken;
    }

    private static void clearXsuaaToken() {
        SecurityContext ctx = SecurityContext.get();
        if (ctx.xsuaaToken != null) {
            LOGGER.debug("XSUAA token removed from SecurityContext (thread-locally).");
            ctx.xsuaaToken = null;
        }
    }

    @Nullable
    public static Certificate getClientCertificate() {
        return SecurityContext.get().certificate;
    }

    public static void setClientCertificate(Certificate certificate) {
        LOGGER.debug("Sets certificate to SecurityContext (thread-locally). {}", (Object)certificate);
        SecurityContext.get().certificate = certificate;
    }

    private static void clearCertificate() {
        SecurityContext ctx = SecurityContext.get();
        if (ctx.certificate != null) {
            LOGGER.debug("Certificate removed from SecurityContext (thread-locally).");
            ctx.certificate = null;
        }
    }

    @Nullable
    public static List<String> getServicePlans() {
        return SecurityContext.get().servicePlans;
    }

    public static void setServicePlans(String servicePlansHeader) {
        String[] planParts = servicePlansHeader.trim().split("\\s*,\\s*");
        List plans = Arrays.stream(planParts).map(plan -> plan.substring(1, plan.length() - 1)).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Sets Identity Service Plan {} to SecurityContext (thread-locally).", plans);
        }
        SecurityContext.get().servicePlans = plans;
    }

    public static void clearServicePlans() {
        SecurityContext ctx = SecurityContext.get();
        if (ctx.servicePlans != null && !ctx.servicePlans.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Service plans {} removed from SecurityContext (thread-locally).", ctx.servicePlans);
            }
            ctx.servicePlans = null;
        }
    }

    public static void registerIdTokenExtension(IdTokenExtension ext) {
        idTokenExtension = ext;
    }

    public static void registerXsuaaTokenExtension(XsuaaTokenExtension ext) {
        xsuaaTokenExtension = ext;
    }

    public static void clear() {
        SecurityContext.clearToken();
        SecurityContext.clearInitialToken();
        SecurityContext.clearIdToken();
        SecurityContext.clearXsuaaToken();
        SecurityContext.clearCertificate();
        SecurityContext.clearServicePlans();
    }

    public static void clearContext() {
        contextStorage.remove();
        LOGGER.debug("Entire SecurityContext removed (thread-locally).");
    }
}

