/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config.cf;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.cf.CFEnvParser;
import com.sap.cloud.security.json.JsonParsingException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcapServicesParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(VcapServicesParser.class);
    private final OAuth2ServiceConfigurationBuilder oAuth2ServiceConfigurationBuilder;

    private VcapServicesParser(OAuth2ServiceConfiguration oAuth2ServiceConfiguration) {
        this.checkProperties(oAuth2ServiceConfiguration);
        this.oAuth2ServiceConfigurationBuilder = OAuth2ServiceConfigurationBuilder.fromConfiguration((OAuth2ServiceConfiguration)oAuth2ServiceConfiguration).withProperty("verificationkey", null);
    }

    public static VcapServicesParser fromFile(String configurationResourceName) {
        String vcapServicesJson = VcapServicesParser.read(configurationResourceName);
        OAuth2ServiceConfiguration oAuth2ServiceConfiguration = VcapServicesParser.findConfiguration(vcapServicesJson);
        return new VcapServicesParser(oAuth2ServiceConfiguration);
    }

    public OAuth2ServiceConfiguration createConfiguration() {
        return this.getConfigurationBuilder().build();
    }

    public OAuth2ServiceConfigurationBuilder getConfigurationBuilder() {
        return this.oAuth2ServiceConfigurationBuilder;
    }

    private void checkProperties(OAuth2ServiceConfiguration oAuth2ServiceConfiguration) {
        if (!VcapServicesParser.nullOrEmpty(oAuth2ServiceConfiguration.getProperty("verificationkey"))) {
            LOGGER.warn("Ignoring verification key from service binding!");
        }
        if (!VcapServicesParser.nullOrEmpty(oAuth2ServiceConfiguration.getClientSecret())) {
            throw new JsonParsingException("Client secret must not be provided!");
        }
    }

    private static OAuth2ServiceConfiguration findConfiguration(String vcapServicesJson) {
        Map serviceToConfigurations = CFEnvParser.loadAll((String)vcapServicesJson, (String)"{}");
        List oAuth2ServiceConfigurations = serviceToConfigurations.values().stream().flatMap(configurations -> configurations.stream()).collect(Collectors.toList());
        if (oAuth2ServiceConfigurations.isEmpty()) {
            throw new JsonParsingException("No supported binding found in VCAP_SERVICES!");
        }
        if (oAuth2ServiceConfigurations.size() > 1) {
            LOGGER.warn("More than one binding found. Taking first one!");
        }
        return (OAuth2ServiceConfiguration)oAuth2ServiceConfigurations.get(0);
    }

    private static String read(String resourceName) {
        try {
            return IOUtils.resourceToString((String)resourceName, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading resource file: " + e.getMessage());
        }
    }

    private static boolean nullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

