/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.test.ApplicationServerOptions;
import com.sap.cloud.security.test.JwtGenerator;
import com.sap.cloud.security.test.SecurityTest;
import com.sap.cloud.security.test.api.ApplicationServerConfiguration;
import com.sap.cloud.security.test.api.SecurityTestContext;
import com.sap.cloud.security.test.api.ServiceMockConfiguration;
import com.sap.cloud.security.token.Token;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.rules.ExternalResource;

public class SecurityTestRule
extends ExternalResource
implements SecurityTestContext,
ServiceMockConfiguration,
ApplicationServerConfiguration {
    public static final String DEFAULT_APP_ID = "xsapp!t0815";
    public static final String DEFAULT_CLIENT_ID = "sb-clientId!t0815";
    public static final String DEFAULT_DOMAIN = "localhost";
    SecurityTest base;

    private SecurityTestRule() {
    }

    public static SecurityTestRule getInstance(Service service) {
        SecurityTestRule instance = new SecurityTestRule();
        instance.base = new SecurityTest(service);
        return instance;
    }

    @Override
    public SecurityTestRule useApplicationServer() {
        this.base.useApplicationServer();
        return this;
    }

    @Override
    public SecurityTestRule useApplicationServer(ApplicationServerOptions applicationServerOptions) {
        this.base.useApplicationServer(applicationServerOptions);
        return this;
    }

    @Override
    public SecurityTestRule addApplicationServlet(Class<? extends Servlet> servletClass, String path) {
        this.base.addApplicationServlet((Class)servletClass, path);
        return this;
    }

    @Override
    public SecurityTestRule addApplicationServlet(ServletHolder servletHolder, String path) {
        this.base.addApplicationServlet(servletHolder, path);
        return this;
    }

    @Override
    public SecurityTestRule addApplicationServletFilter(Class<? extends Filter> filterClass) {
        this.base.addApplicationServletFilter((Class)filterClass);
        return this;
    }

    @Override
    public SecurityTestRule setPort(int port) {
        this.base.setPort(port);
        return this;
    }

    @Override
    public SecurityTestRule setKeys(String publicKeyPath, String privateKeyPath) {
        this.base.setKeys(publicKeyPath, privateKeyPath);
        return this;
    }

    protected void before() throws Exception {
        this.base.setup();
    }

    @Override
    public JwtGenerator getPreconfiguredJwtGenerator() {
        return this.base.getPreconfiguredJwtGenerator();
    }

    @Override
    public JwtGenerator getJwtGeneratorFromFile(String tokenJsonResource) {
        return this.base.getJwtGeneratorFromFile(tokenJsonResource);
    }

    @Override
    public OAuth2ServiceConfigurationBuilder getOAuth2ServiceConfigurationBuilderFromFile(String configurationJson) {
        return this.base.getOAuth2ServiceConfigurationBuilderFromFile(configurationJson);
    }

    @Deprecated
    public OAuth2ServiceConfigurationBuilder getConfigurationBuilderFromFile(String configurationJson) {
        return this.base.getOAuth2ServiceConfigurationBuilderFromFile(configurationJson);
    }

    public SecurityTestContext getContext() {
        return this.base;
    }

    @Override
    public Token createToken() {
        return this.base.createToken();
    }

    @Deprecated
    public WireMockRule getWireMockRule() {
        throw new UnsupportedOperationException("Deprecated since version 2.6.0. Please use getWireMockServer instead. WireMockServer is the base class of WireMockRule.");
    }

    @Override
    public WireMockServer getWireMockServer() {
        return this.base.getWireMockServer();
    }

    @Override
    @Nullable
    public String getApplicationServerUri() {
        return this.base.getApplicationServerUri();
    }

    protected void after() {
        this.base.tearDown();
    }
}

