/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test.extension;

import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.test.ApplicationServerOptions;
import com.sap.cloud.security.test.SecurityTest;
import com.sap.cloud.security.test.api.ApplicationServerConfiguration;
import com.sap.cloud.security.test.api.SecurityTestContext;
import com.sap.cloud.security.test.api.ServiceMockConfiguration;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class SecurityTestExtension
implements ParameterResolver,
BeforeAllCallback,
AfterAllCallback,
ServiceMockConfiguration,
ApplicationServerConfiguration {
    private final SecurityTest securityTest;

    SecurityTestExtension(Service service) {
        this.securityTest = new SecurityTest(service);
    }

    SecurityTestExtension(SecurityTest securityTest) {
        this.securityTest = securityTest;
    }

    public static SecurityTestExtension forService(Service service) {
        return new SecurityTestExtension(new SecurityTest(service));
    }

    public SecurityTestContext getContext() {
        return this.securityTest;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.securityTest.setup();
    }

    public void afterAll(ExtensionContext context) {
        this.securityTest.tearDown();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().equals(SecurityTestContext.class);
    }

    public SecurityTestContext resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.securityTest;
    }

    @Override
    public SecurityTestExtension setPort(int port) {
        this.securityTest.setPort(port);
        return this;
    }

    @Override
    public SecurityTestExtension setKeys(String publicKeyPath, String privateKeyPath) {
        this.securityTest.setKeys(publicKeyPath, privateKeyPath);
        return this;
    }

    @Override
    public SecurityTestExtension useApplicationServer() {
        this.securityTest.useApplicationServer();
        return this;
    }

    @Override
    public SecurityTestExtension useApplicationServer(ApplicationServerOptions options) {
        this.securityTest.useApplicationServer(options);
        return this;
    }

    @Override
    public SecurityTestExtension addApplicationServlet(Class<? extends Servlet> servletClass, String path) {
        this.securityTest.addApplicationServlet((Class)servletClass, path);
        return this;
    }

    @Override
    public SecurityTestExtension addApplicationServlet(ServletHolder servletHolder, String path) {
        this.securityTest.addApplicationServlet(servletHolder, path);
        return this;
    }

    @Override
    public SecurityTestExtension addApplicationServletFilter(Class<? extends Filter> filterClass) {
        this.securityTest.addApplicationServletFilter((Class)filterClass);
        return this;
    }
}

