/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.config.cf.VcapServicesParser;
import com.sap.cloud.security.test.ApplicationServerOptions;
import com.sap.cloud.security.test.JwtGenerator;
import com.sap.cloud.security.test.RSAKeys;
import com.sap.cloud.security.test.SecurityFilter;
import com.sap.cloud.security.test.api.ApplicationServerConfiguration;
import com.sap.cloud.security.test.api.SecurityTestContext;
import com.sap.cloud.security.test.api.ServiceMockConfiguration;
import com.sap.cloud.security.test.jetty.JettyTokenAuthenticator;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import com.sap.cloud.security.xsuaa.http.MediaType;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTest
implements SecurityTestContext,
ServiceMockConfiguration,
ApplicationServerConfiguration {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SecurityTest.class);
    public static final String DEFAULT_APP_ID = "xsapp!t0815";
    public static final String DEFAULT_CLIENT_ID = "sb-clientId!t0815";
    public static final String DEFAULT_DOMAIN = "localhost";
    public static final String DEFAULT_UAA_DOMAIN = "http://localhost";
    public static final String DEFAULT_URL = "http://localhost";
    protected static final String LOCALHOST_PATTERN = "http://localhost:%d";
    protected final Map<String, ServletHolder> applicationServletsByPath = new HashMap<String, ServletHolder>();
    protected final List<FilterHolder> applicationServletFilters = new ArrayList<FilterHolder>();
    protected Server applicationServer;
    protected ApplicationServerOptions applicationServerOptions;
    protected boolean useApplicationServer;
    protected WireMockServer wireMockServer;
    protected RSAKeys keys;
    protected final Service service;
    protected static final String clientId = "sb-clientId!t0815";
    protected String jwksUrl;
    private String issuerUrl;

    public SecurityTest(Service service) {
        this.service = service;
        this.keys = RSAKeys.generate();
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().dynamicPort());
    }

    @Override
    public SecurityTest useApplicationServer() {
        this.useApplicationServer = true;
        return this;
    }

    @Override
    public SecurityTest useApplicationServer(ApplicationServerOptions applicationServerOptions) {
        this.applicationServerOptions = applicationServerOptions;
        this.useApplicationServer = true;
        return this;
    }

    @Override
    public SecurityTest addApplicationServlet(Class<? extends Servlet> servletClass, String path) {
        this.applicationServletsByPath.put(path, new ServletHolder(servletClass));
        return this;
    }

    @Override
    public SecurityTest addApplicationServlet(ServletHolder servletHolder, String path) {
        this.applicationServletsByPath.put(path, servletHolder);
        return this;
    }

    @Override
    public SecurityTest addApplicationServletFilter(Class<? extends Filter> filterClass) {
        this.applicationServletFilters.add(new FilterHolder(filterClass));
        return this;
    }

    @Override
    public SecurityTest setPort(int port) {
        this.wireMockServer = new WireMockServer((Options)WireMockConfiguration.options().port(port));
        return this;
    }

    @Override
    public SecurityTest setKeys(String publicKeyPath, String privateKeyPath) {
        try {
            this.keys = RSAKeys.fromKeyFiles(publicKeyPath, privateKeyPath);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    @Override
    public JwtGenerator getPreconfiguredJwtGenerator() {
        JwtGenerator jwtGenerator = JwtGenerator.getInstance(this.service, "sb-clientId!t0815").withPrivateKey(this.keys.getPrivate());
        if (this.jwksUrl == null || this.issuerUrl == null) {
            LOGGER.warn("Method getPreconfiguredJwtGenerator was called too soon. Cannot set mock jwks/issuer url!");
        }
        if (Service.XSUAA.equals((Object)this.service)) {
            jwtGenerator.withHeaderParameter("jku", this.jwksUrl).withAppId(DEFAULT_APP_ID).withClaimValue("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        }
        return jwtGenerator.withClaimValue("iss", this.issuerUrl);
    }

    @Override
    public JwtGenerator getJwtGeneratorFromFile(String tokenJsonResource) {
        JwtGenerator jwtGenerator = JwtGenerator.getInstanceFromFile(this.service, tokenJsonResource).withClaimValue("iss", this.issuerUrl).withPrivateKey(this.keys.getPrivate());
        if (Service.XSUAA == this.service) {
            jwtGenerator.withHeaderParameter("jku", this.jwksUrl);
        }
        return jwtGenerator;
    }

    @Override
    public OAuth2ServiceConfigurationBuilder getOAuth2ServiceConfigurationBuilderFromFile(String configurationResourceName) {
        return VcapServicesParser.fromFile(configurationResourceName).getConfigurationBuilder().withDomains(new String[]{this.issuerUrl}).withUrl(this.issuerUrl);
    }

    @Override
    public Token createToken() {
        return this.getPreconfiguredJwtGenerator().createToken();
    }

    @Override
    public WireMockServer getWireMockServer() {
        return this.wireMockServer;
    }

    @Override
    @Nullable
    public String getApplicationServerUri() {
        if (this.useApplicationServer) {
            return String.format(LOCALHOST_PATTERN, this.applicationServer.getURI().getPort());
        }
        return null;
    }

    void startApplicationServer() throws Exception {
        WebAppContext context = this.createWebAppContext();
        ServletHandler servletHandler = this.createServletHandler(context);
        this.applicationServletsByPath.forEach((path, servletHolder) -> servletHandler.addServletWithMapping(servletHolder, path));
        this.applicationServletFilters.forEach(filterHolder -> servletHandler.addFilterWithMapping(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST)));
        servletHandler.addFilterWithMapping(new FilterHolder((Filter)new SecurityFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        this.applicationServer = new Server(this.applicationServerOptions.getPort());
        this.applicationServer.setHandler((Handler)context);
        this.applicationServer.start();
    }

    ServletHandler createServletHandler(WebAppContext context) {
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        JettyTokenAuthenticator authenticator = new JettyTokenAuthenticator(this.applicationServerOptions.getTokenAuthenticator());
        security.setAuthenticator((Authenticator)authenticator);
        ServletHandler servletHandler = new ServletHandler();
        security.setHandler((Handler)servletHandler);
        context.setServletHandler(servletHandler);
        context.setSecurityHandler((SecurityHandler)security);
        return servletHandler;
    }

    WebAppContext createWebAppContext() {
        WebAppContext context = new WebAppContext();
        context.setConfigurations(new Configuration[]{new AnnotationConfiguration(), new WebXmlConfiguration(), new WebInfConfiguration(), new PlusConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration()});
        context.setContextPath("/");
        context.setResourceBase("src/main/java/webapp");
        context.setParentLoaderPriority(true);
        return context;
    }

    String createDefaultTokenKeyResponse() throws IOException {
        String encodedPublicKeyModulus = Base64.getUrlEncoder().encodeToString(((RSAPublicKey)this.keys.getPublic()).getModulus().toByteArray());
        String encodedPublicKey = Base64.getEncoder().encodeToString(this.keys.getPublic().getEncoded());
        return IOUtils.resourceToString((String)"/token_keys_template.json", (Charset)StandardCharsets.UTF_8).replace("$kid", this.getKeyId()).replace("$public_key", encodedPublicKey).replace("$modulus", encodedPublicKeyModulus);
    }

    private String getKeyId() {
        return this.service == Service.IAS ? "default-kid-ias" : "default-kid";
    }

    String createDefaultOidcConfigurationResponse() throws IOException {
        return IOUtils.resourceToString((String)"/oidcConfigurationTemplate.json", (Charset)StandardCharsets.UTF_8).replace("$issuer", this.wireMockServer.baseUrl());
    }

    public void setup() throws Exception {
        if (!this.wireMockServer.isRunning()) {
            this.wireMockServer.start();
        } else {
            this.wireMockServer.resetAll();
        }
        if (this.useApplicationServer && (this.applicationServer == null || !this.applicationServer.isStarted())) {
            if (this.applicationServerOptions == null) {
                this.applicationServerOptions = ApplicationServerOptions.forService(this.service, this.wireMockServer.port());
            }
            this.startApplicationServer();
        }
        XsuaaDefaultEndpoints endpointsProvider = new XsuaaDefaultEndpoints(String.format(LOCALHOST_PATTERN, this.wireMockServer.port()), null);
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlPathEqualTo((String)endpointsProvider.getJwksUri().getPath())).willReturn(WireMock.aResponse().withBody(this.createDefaultTokenKeyResponse()).withHeader("Content-Type", new String[]{MediaType.APPLICATION_JSON.value()})));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/.well-known/openid-configuration")).willReturn(WireMock.aResponse().withBody(this.createDefaultOidcConfigurationResponse()).withHeader("Content-Type", new String[]{MediaType.APPLICATION_JSON.value()})));
        this.jwksUrl = endpointsProvider.getJwksUri().toString();
        this.issuerUrl = this.wireMockServer.baseUrl();
    }

    public void tearDown() {
        this.shutdownWireMock();
        try {
            if (this.useApplicationServer) {
                this.applicationServer.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop jetty server", (Throwable)e);
        }
    }

    private void shutdownWireMock() {
        this.wireMockServer.shutdown();
        int maxTries = 100;
        for (int tries = 0; tries < maxTries && this.wireMockServer.isRunning(); ++tries) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn("Got interrupted while waiting for WireMock to shutdown. Giving up!");
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

