/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.stream.Collectors;

public class RSAKeys {
    private static final String RSA = "RSA";
    private static final String KEY_BEGIN_END_REGEX = "-+(BEGIN|END)\\s+(\\w+\\s?)+-+";
    private final KeyPair keyPair;

    public static RSAKeys generate() {
        KeyPair theKeyPair = RSAKeys.generateKeyPair();
        return new RSAKeys(new KeyPair(theKeyPair.getPublic(), theKeyPair.getPrivate()));
    }

    public static RSAKeys fromKeyFiles(String publicKeyPath, String privateKeyPath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyPair keyPair = new KeyPair(RSAKeys.loadPublicKey(publicKeyPath), RSAKeys.loadPrivateKey(privateKeyPath));
        return new RSAKeys(keyPair);
    }

    public PublicKey getPublic() {
        return this.keyPair.getPublic();
    }

    public PrivateKey getPrivate() {
        return this.keyPair.getPrivate();
    }

    private RSAKeys(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public static PublicKey loadPublicKey(String publicKeyPath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String publicKeyString = RSAKeys.readFileAndReplaceBeginEnd(Paths.get(publicKeyPath, new String[0]));
        X509EncodedKeySpec spec = new X509EncodedKeySpec(RSAKeys.base64Decode(publicKeyString));
        return KeyFactory.getInstance(RSA).generatePublic(spec);
    }

    public static PrivateKey loadPrivateKey(String privateKeyPath) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        String privateKeyString = RSAKeys.readFileAndReplaceBeginEnd(Paths.get(privateKeyPath, new String[0]));
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(RSAKeys.base64Decode(privateKeyString));
        return KeyFactory.getInstance(RSA).generatePrivate(spec);
    }

    private static byte[] base64Decode(String publicKeyString) {
        return Base64.getDecoder().decode(publicKeyString);
    }

    private static String readFileAndReplaceBeginEnd(Path filePath) throws IOException {
        String content = Files.readAllLines(filePath).stream().collect(Collectors.joining(""));
        return content.replaceAll(KEY_BEGIN_END_REGEX, "");
    }

    private static KeyPair generateKeyPair() {
        try {
            return KeyPairGenerator.getInstance(RSA).generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

