/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.servlet.TokenAuthenticator;
import com.sap.cloud.security.servlet.XsuaaTokenAuthenticator;
import com.sap.cloud.security.xsuaa.Assertions;

public class ApplicationServerOptions {
    private final TokenAuthenticator tokenAuthenticator;
    private int port;

    private ApplicationServerOptions(TokenAuthenticator tokenAuthenticator) {
        this(tokenAuthenticator, 0);
    }

    private ApplicationServerOptions(TokenAuthenticator tokenAuthenticator, int port) {
        this.tokenAuthenticator = tokenAuthenticator;
        this.port = port;
    }

    public static ApplicationServerOptions forXsuaaService(String appId, String clientId) {
        Assertions.assertHasText((String)appId, (String)"appId is required by the XsuaaAudienceValidator");
        Assertions.assertHasText((String)clientId, (String)"clientId is required by the XsuaaAudienceValidator");
        return new ApplicationServerOptions((TokenAuthenticator)new XsuaaTokenAuthenticator().withServiceConfiguration(ApplicationServerOptions.createServiceConfiguration(appId, clientId)));
    }

    public static ApplicationServerOptions forService(Service service) {
        ApplicationServerOptions instance;
        switch (service) {
            case XSUAA: {
                instance = ApplicationServerOptions.forXsuaaService("xsapp!t0815", "sb-clientId!t0815");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Identity Service " + service + " is not yet supported.");
            }
        }
        return instance;
    }

    public ApplicationServerOptions useTokenAuthenticator(TokenAuthenticator tokenAuthenticator) {
        return new ApplicationServerOptions(tokenAuthenticator, this.port);
    }

    public ApplicationServerOptions usePort(int port) {
        return new ApplicationServerOptions(this.tokenAuthenticator, port);
    }

    public TokenAuthenticator getTokenAuthenticator() {
        return this.tokenAuthenticator;
    }

    public int getPort() {
        return this.port;
    }

    private static OAuth2ServiceConfiguration createServiceConfiguration(String appId, String clientId) {
        return OAuth2ServiceConfigurationBuilder.forService((Service)Service.XSUAA).withClientId(clientId).withProperty("xsappname", appId).withProperty("uaadomain", "localhost").build();
    }
}

