/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.test.ApplicationServerOptions;
import com.sap.cloud.security.test.JwtGenerator;
import com.sap.cloud.security.test.RSAKeys;
import com.sap.cloud.security.test.SecurityFilter;
import com.sap.cloud.security.test.jetty.JettyTokenAuthenticator;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.client.XsuaaDefaultEndpoints;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityTestRule
extends ExternalResource {
    public static final String DEFAULT_APP_ID = "xsapp!t0815";
    public static final String DEFAULT_CLIENT_ID = "sb-clientId!t0815";
    public static final String DEFAULT_DOMAIN = "localhost";
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityTestRule.class);
    private static final String LOCALHOST_PATTERN = "http://localhost:%d";
    private final Map<String, ServletHolder> applicationServletsByPath = new HashMap<String, ServletHolder>();
    private final List<FilterHolder> applicationServletFilters = new ArrayList<FilterHolder>();
    private Server applicationServer;
    private ApplicationServerOptions applicationServerOptions;
    private boolean useApplicationServer;
    private WireMockRule wireMockRule;
    private RSAKeys keys;
    private int wireMockPort = 0;
    private Service service;
    private String clientId = "sb-clientId!t0815";
    private String jwksUrl;

    private SecurityTestRule() {
    }

    public static SecurityTestRule getInstance(Service service) {
        SecurityTestRule instance = new SecurityTestRule();
        instance.keys = RSAKeys.generate();
        instance.service = service;
        ApplicationServerOptions.forService(service);
        return instance;
    }

    public SecurityTestRule useApplicationServer() {
        return this.useApplicationServer(ApplicationServerOptions.forService(this.service));
    }

    public SecurityTestRule useApplicationServer(ApplicationServerOptions applicationServerOptions) {
        this.applicationServerOptions = applicationServerOptions;
        this.useApplicationServer = true;
        return this;
    }

    public SecurityTestRule addApplicationServlet(Class<? extends Servlet> servletClass, String path) {
        this.applicationServletsByPath.put(path, new ServletHolder(servletClass));
        return this;
    }

    public SecurityTestRule addApplicationServlet(ServletHolder servletHolder, String path) {
        this.applicationServletsByPath.put(path, servletHolder);
        return this;
    }

    public SecurityTestRule addApplicationServletFilter(Class<? extends Filter> filterClass) {
        this.applicationServletFilters.add(new FilterHolder(filterClass));
        return this;
    }

    public SecurityTestRule setPort(int port) {
        this.wireMockPort = port;
        return this;
    }

    public SecurityTestRule setKeys(String publicKeyPath, String privateKeyPath) {
        try {
            this.keys = RSAKeys.fromKeyFiles(publicKeyPath, privateKeyPath);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    protected void before() throws Exception {
        if (this.useApplicationServer) {
            this.startApplicationServer();
        }
        this.setupWireMock();
    }

    public JwtGenerator getPreconfiguredJwtGenerator() {
        JwtGenerator jwtGenerator = JwtGenerator.getInstance(this.service, this.clientId).withPrivateKey(this.keys.getPrivate());
        switch (this.service) {
            case XSUAA: {
                jwtGenerator.withHeaderParameter("jku", this.jwksUrl).withClaimValue("grant_type", "user_token");
                break;
            }
            default: {
                jwtGenerator.withClaimValue("iss", this.wireMockRule.baseUrl());
            }
        }
        return jwtGenerator;
    }

    public Token createToken() {
        return this.getPreconfiguredJwtGenerator().createToken();
    }

    @Nullable
    public WireMockRule getWireMockRule() {
        return this.wireMockRule;
    }

    @Nullable
    public String getApplicationServerUri() {
        if (this.useApplicationServer) {
            return String.format(LOCALHOST_PATTERN, this.applicationServer.getURI().getPort());
        }
        return null;
    }

    private void setupWireMock() throws IOException {
        this.wireMockRule = this.wireMockPort == 0 ? new WireMockRule((Options)WireMockConfiguration.options().dynamicPort()) : new WireMockRule((Options)WireMockConfiguration.options().port(this.wireMockPort));
        this.wireMockRule.start();
        this.wireMockPort = this.wireMockRule.port();
        XsuaaDefaultEndpoints endpointsProvider = new XsuaaDefaultEndpoints(String.format(LOCALHOST_PATTERN, this.wireMockPort));
        this.wireMockRule.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)endpointsProvider.getJwksUri().getPath())).willReturn(WireMock.aResponse().withBody(this.createDefaultTokenKeyResponse())));
        this.wireMockRule.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/.well-known/openid-configuration")).willReturn(WireMock.aResponse().withBody(this.createDefaultOidcConfigurationResponse())));
        this.jwksUrl = endpointsProvider.getJwksUri().toString();
    }

    protected void after() {
        this.wireMockRule.shutdown();
        try {
            if (this.useApplicationServer) {
                this.applicationServer.stop();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop jetty server", (Throwable)e);
        }
    }

    private void startApplicationServer() throws Exception {
        WebAppContext context = this.createWebAppContext();
        ServletHandler servletHandler = this.createServletHandler(context);
        this.applicationServletsByPath.forEach((path, servletHolder) -> servletHandler.addServletWithMapping(servletHolder, path));
        this.applicationServletFilters.forEach(filterHolder -> servletHandler.addFilterWithMapping(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST)));
        servletHandler.addFilterWithMapping(new FilterHolder((Filter)new SecurityFilter()), "/*", EnumSet.of(DispatcherType.REQUEST));
        this.applicationServer = new Server(this.applicationServerOptions.getPort());
        this.applicationServer.setHandler((Handler)context);
        this.applicationServer.start();
    }

    private ServletHandler createServletHandler(WebAppContext context) {
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        JettyTokenAuthenticator authenticator = new JettyTokenAuthenticator(this.applicationServerOptions.getTokenAuthenticator());
        security.setAuthenticator((Authenticator)authenticator);
        ServletHandler servletHandler = new ServletHandler();
        security.setHandler((Handler)servletHandler);
        context.setServletHandler(servletHandler);
        context.setSecurityHandler((SecurityHandler)security);
        return servletHandler;
    }

    private WebAppContext createWebAppContext() {
        WebAppContext context = new WebAppContext();
        context.setConfigurations(new Configuration[]{new AnnotationConfiguration(), new WebXmlConfiguration(), new WebInfConfiguration(), new PlusConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration()});
        context.setContextPath("/");
        context.setResourceBase("src/main/java/webapp");
        context.setParentLoaderPriority(true);
        return context;
    }

    private String createDefaultTokenKeyResponse() throws IOException {
        String encodedPublicKeyModulus = Base64.getUrlEncoder().encodeToString(((RSAPublicKey)this.keys.getPublic()).getModulus().toByteArray());
        String encodedPublicKey = Base64.getEncoder().encodeToString(this.keys.getPublic().getEncoded());
        return IOUtils.resourceToString((String)"/token_keys_template.json", (Charset)StandardCharsets.UTF_8).replace("$kid", "default-kid").replace("$public_key", encodedPublicKey).replace("$modulus", encodedPublicKeyModulus);
    }

    private String createDefaultOidcConfigurationResponse() throws IOException {
        return IOUtils.resourceToString((String)"/oidcConfigurationTemplate.json", (Charset)StandardCharsets.UTF_8).replace("$issuer", this.wireMockRule.baseUrl());
    }
}

