/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.test.ApplicationServerOptions;
import com.sap.cloud.security.test.JwtGenerator;
import com.sap.cloud.security.test.SecurityTest;
import com.sap.cloud.security.token.Token;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.rules.ExternalResource;

public class SecurityTestRule
extends ExternalResource {
    public static final String DEFAULT_APP_ID = "xsapp!t0815";
    public static final String DEFAULT_CLIENT_ID = "sb-clientId!t0815";
    public static final String DEFAULT_DOMAIN = "localhost";
    SecurityTest base;

    private SecurityTestRule() {
    }

    public static SecurityTestRule getInstance(Service service) {
        SecurityTestRule instance = new SecurityTestRule();
        instance.base = new SecurityTest(service);
        return instance;
    }

    public SecurityTestRule useApplicationServer() {
        this.base.useApplicationServer();
        return this;
    }

    public SecurityTestRule useApplicationServer(ApplicationServerOptions applicationServerOptions) {
        this.base.useApplicationServer(applicationServerOptions);
        return this;
    }

    public SecurityTestRule addApplicationServlet(Class<? extends Servlet> servletClass, String path) {
        this.base.addApplicationServlet(servletClass, path);
        return this;
    }

    public SecurityTestRule addApplicationServlet(ServletHolder servletHolder, String path) {
        this.base.addApplicationServlet(servletHolder, path);
        return this;
    }

    public SecurityTestRule addApplicationServletFilter(Class<? extends Filter> filterClass) {
        this.base.addApplicationServletFilter(filterClass);
        return this;
    }

    public SecurityTestRule setPort(int port) {
        this.base.setPort(port);
        return this;
    }

    public SecurityTestRule setKeys(String publicKeyPath, String privateKeyPath) {
        this.base.setKeys(publicKeyPath, privateKeyPath);
        return this;
    }

    protected void before() throws Exception {
        this.base.setup();
    }

    public JwtGenerator getPreconfiguredJwtGenerator() {
        return this.base.getPreconfiguredJwtGenerator();
    }

    public JwtGenerator getJwtGeneratorFromFile(String tokenJsonResource) throws IOException {
        return this.base.getJwtGeneratorFromFile(tokenJsonResource);
    }

    public OAuth2ServiceConfigurationBuilder getConfigurationBuilderFromFile(String tokenJsonResource) {
        return this.base.getConfigurationBuilderFromFile(tokenJsonResource);
    }

    public Token createToken() {
        return this.base.createToken();
    }

    @Nullable
    @Deprecated
    public WireMockRule getWireMockRule() {
        throw new UnsupportedOperationException("Deprecated since version 2.6.0. Please use getWireMockServer instead. WireMockServer is the base class of WireMockRule.");
    }

    @Nullable
    public WireMockServer getWireMockServer() {
        return this.base.getWireMockServer();
    }

    @Nullable
    public String getApplicationServerUri() {
        return this.base.getApplicationServerUri();
    }

    protected void after() {
        this.base.tearDown();
    }
}

