/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test.jetty;

import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticator;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyTokenAuthenticator
implements Authenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JettyTokenAuthenticator.class);
    private final TokenAuthenticator tokenAuthenticator;

    public JettyTokenAuthenticator(TokenAuthenticator tokenAuthenticator) {
        this.tokenAuthenticator = tokenAuthenticator;
    }

    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) {
        TokenAuthenticationResult tokenAuthenticationResult = this.tokenAuthenticator.validateRequest(request, response);
        if (tokenAuthenticationResult.isAuthenticated()) {
            return this.createAuthentication(tokenAuthenticationResult);
        }
        this.sendUnauthenticatedResponse(response, tokenAuthenticationResult.getUnauthenticatedReason());
        return Authentication.UNAUTHENTICATED;
    }

    private void sendUnauthenticatedResponse(ServletResponse response, String unauthenticatedReason) {
        if (response instanceof HttpServletResponse) {
            try {
                HttpServletResponse httpServletResponse = (HttpServletResponse)response;
                httpServletResponse.sendError(401, unauthenticatedReason);
            }
            catch (IOException e) {
                LOGGER.error("Failed to send error response", (Throwable)e);
            }
        }
    }

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
    }

    public String getAuthMethod() {
        return "Token";
    }

    public void prepareRequest(ServletRequest request) {
    }

    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }

    private Authentication createAuthentication(TokenAuthenticationResult tokenAuthentication) {
        Principal principal = tokenAuthentication.getPrincipal();
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(principal);
        Subject subject = new Subject(true, principals, new HashSet(), new HashSet());
        String[] scopes = tokenAuthentication.getScopes().toArray(new String[0]);
        return new UserAuthentication(this.getAuthMethod(), (UserIdentity)new DefaultUserIdentity(subject, principal, scopes));
    }
}

