/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.test.jetty;

import com.sap.cloud.security.servlet.TokenAuthenticationResult;
import com.sap.cloud.security.servlet.TokenAuthenticator;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.security.Principal;
import java.util.HashSet;
import java.util.function.Function;
import javax.security.auth.Subject;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.security.AuthenticationState;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserIdentity;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.internal.DefaultUserIdentity;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.util.Callback;

public class JettyTokenAuthenticator
implements Authenticator {
    private final TokenAuthenticator tokenAuthenticator;

    public JettyTokenAuthenticator(TokenAuthenticator tokenAuthenticator) {
        this.tokenAuthenticator = tokenAuthenticator;
    }

    public void setConfiguration(Authenticator.Configuration configuration) {
    }

    public String getAuthenticationType() {
        return "Token";
    }

    public Constraint.Authorization getConstraintAuthentication(String pathInContext, Constraint.Authorization existing, Function<Boolean, Session> getSession) {
        return Constraint.Authorization.ANY_USER;
    }

    public AuthenticationState validateRequest(Request request, Response response, Callback callback) throws ServerAuthException {
        ServletApiResponse servletApiResponse;
        ServletApiRequest servletRequest;
        if (request instanceof ServletContextRequest) {
            ServletContextRequest scr = (ServletContextRequest)request;
            v0 = scr.getServletApiRequest();
        } else {
            v0 = servletRequest = null;
        }
        if (response instanceof ServletContextResponse) {
            ServletContextResponse scr = (ServletContextResponse)response;
            servletApiResponse = scr.getServletApiResponse();
        } else {
            servletApiResponse = null;
        }
        ServletApiResponse servletResponse = servletApiResponse;
        TokenAuthenticationResult tokenAuthenticationResult = this.tokenAuthenticator.validateRequest((ServletRequest)servletRequest, (ServletResponse)servletResponse);
        if (tokenAuthenticationResult.isAuthenticated()) {
            return this.createAuthentication(tokenAuthenticationResult);
        }
        Response.writeError((Request)request, (Response)response, (Callback)callback, (int)401, (String)tokenAuthenticationResult.getUnauthenticatedReason());
        return AuthenticationState.SEND_FAILURE;
    }

    private AuthenticationState createAuthentication(TokenAuthenticationResult tokenAuthentication) {
        Principal principal = tokenAuthentication.getPrincipal();
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(principal);
        Subject subject = new Subject(true, principals, new HashSet(), new HashSet());
        String[] scopes = tokenAuthentication.getScopes().toArray(new String[0]);
        return new LoginAuthenticator.UserAuthenticationSucceeded(this.getAuthenticationType(), (UserIdentity)new DefaultUserIdentity(subject, principal, scopes));
    }
}

