/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.xsuaa.Assertions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JwtIssuerValidator
implements Validator<Token> {
    private final List<String> domains;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    JwtIssuerValidator(List<String> domains) {
        Assertions.assertNotEmpty(domains, (String)"JwtIssuerValidator requires a domain(s).");
        this.domains = domains;
    }

    @Override
    public ValidationResult validate(Token token) {
        String iasIssuerUrl = token.getClaimAsString("ias_iss");
        String issuerUrl = token.getClaimAsString("iss");
        ValidationResult validationResult = this.validateUrl(issuerUrl, "iss");
        if (validationResult.isErroneous()) {
            return validationResult;
        }
        if (JwtIssuerValidator.hasValue(iasIssuerUrl)) {
            validationResult = this.validateUrl(iasIssuerUrl, "ias_iss");
            if (validationResult.isErroneous()) {
                return validationResult;
            }
            return this.matchesTokenIssuerUrl(iasIssuerUrl, "ias_iss");
        }
        return this.matchesTokenIssuerUrl(issuerUrl, "iss");
    }

    private ValidationResult matchesTokenIssuerUrl(String issuer, String claimName) {
        URI issuerUri = URI.create(issuer);
        if (issuerUri.getQuery() == null && issuerUri.getFragment() == null && issuerUri.getHost() != null) {
            for (String d : this.domains) {
                if (!issuerUri.getHost().endsWith(d)) continue;
                return ValidationResults.createValid();
            }
        }
        return ValidationResults.createInvalid("Issuer is not trusted because '{}' '{}' doesn't match any of these domains '{}' of the identity provider.", claimName, issuer, this.domains);
    }

    private ValidationResult validateUrl(String issuer, String claimName) {
        try {
            if (issuer == null || issuer.trim().isEmpty()) {
                return ValidationResults.createInvalid("Issuer validation can not be performed because Jwt token does not contain '{}' claim.", claimName);
            }
            if (!issuer.startsWith("http")) {
                return ValidationResults.createInvalid("Issuer is not trusted because '{}' claim '{}' does not provide a valid URI (missing http scheme). Please contact your Identity Provider Administrator.", claimName, issuer);
            }
            URI issuerUri = new URI(issuer);
            if (issuerUri.getQuery() == null && issuerUri.getFragment() == null && issuerUri.getHost() != null) {
                return ValidationResults.createValid();
            }
        }
        catch (URISyntaxException e) {
            this.logger.error("Error: '{}' claim '{}' does not provide a valid URI: {}. Please contact your Identity Provider Administrator.", new Object[]{claimName, issuer, e.getMessage(), e});
        }
        return ValidationResults.createInvalid("Issuer is not trusted because '{}' claim '{}' does not provide a valid URI. Please contact your Identity Provider Administrator.", claimName, issuer);
    }

    private static boolean hasValue(String issuer) {
        return issuer != null && !issuer.trim().isEmpty();
    }
}

