/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.config.cf;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.config.OAuth2ServiceConfigurationBuilder;
import com.sap.cloud.security.config.Service;
import com.sap.cloud.security.json.DefaultJsonObject;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.json.JsonParsingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CFEnvParser {
    private static final Logger logger = LoggerFactory.getLogger(CFEnvParser.class);

    private CFEnvParser() {
    }

    static OAuth2ServiceConfiguration loadForService(Service service, JsonObject serviceJsonObject) {
        return CFEnvParser.loadForService(service, serviceJsonObject, false);
    }

    static Map<Service, List<OAuth2ServiceConfiguration>> loadAll(String vcapServicesJson, String vcapApplicationJson) {
        HashMap<Service, List<OAuth2ServiceConfiguration>> serviceConfigurations = new HashMap<Service, List<OAuth2ServiceConfiguration>>();
        for (Service service : Service.values()) {
            List<OAuth2ServiceConfiguration> allServices = CFEnvParser.loadAllForService(service, new DefaultJsonObject(vcapServicesJson), CFEnvParser.runInLegacyMode(vcapApplicationJson));
            serviceConfigurations.put(service, allServices);
        }
        return serviceConfigurations;
    }

    static List<OAuth2ServiceConfiguration> loadAllForService(Service service, JsonObject vcapServicesJson, boolean isLegacyMode) {
        List serviceJsonObjects = vcapServicesJson.getJsonObjects(service.getCFName());
        if (service == Service.XSUAA && serviceJsonObjects.size() > 1) {
            logger.info("More than one service configuration available for service {}.", (Object)service);
        }
        return serviceJsonObjects.stream().map(serviceJsonObject -> CFEnvParser.loadForService(service, serviceJsonObject, isLegacyMode)).collect(Collectors.toList());
    }

    static OAuth2ServiceConfiguration loadForService(Service service, JsonObject serviceJsonObject, boolean isLegacyMode) {
        Map serviceBindingProperties = serviceJsonObject.getKeyValueMap();
        try {
            Map serviceBindingCredentials = serviceJsonObject.getJsonObject("credentials").getKeyValueMap();
            OAuth2ServiceConfigurationBuilder builder = OAuth2ServiceConfigurationBuilder.forService(service).withProperties(serviceBindingCredentials).withProperty("plan", (String)serviceBindingProperties.get("plan")).runInLegacyMode(isLegacyMode);
            if (Service.IAS == service) {
                builder.withDomains(serviceJsonObject.getJsonObject("credentials").getAsStringList("domains").toArray(new String[0]));
            }
            return builder.build();
        }
        catch (JsonParsingException e) {
            String errDescription = "The credentials of 'VCAP_SERVICES' can not be parsed for service '" + service + "' ('" + e.getMessage() + "'). Please check the service binding.";
            logger.error(errDescription);
            throw new JsonParsingException(errDescription);
        }
    }

    private static boolean runInLegacyMode(String vcapApplicationJson) {
        return new DefaultJsonObject(vcapApplicationJson).contains("xs_api");
    }
}

