/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token;

import com.sap.cloud.security.json.DefaultJsonObject;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.xsuaa.Assertions;
import com.sap.cloud.security.xsuaa.jwt.Base64JwtDecoder;
import com.sap.cloud.security.xsuaa.jwt.DecodedJwt;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONObject;

public abstract class AbstractToken
implements Token {
    private static final long serialVersionUID = 2204172041950251807L;
    private final DecodedJwt decodedJwt;
    protected final DefaultJsonObject tokenHeader;
    protected final DefaultJsonObject tokenBody;

    public AbstractToken(@Nonnull DecodedJwt decodedJwt) {
        this.tokenHeader = new DefaultJsonObject(decodedJwt.getHeader());
        this.tokenBody = new DefaultJsonObject(decodedJwt.getPayload());
        this.decodedJwt = decodedJwt;
    }

    public AbstractToken(@Nonnull String jwtToken) {
        this(Base64JwtDecoder.getInstance().decode(AbstractToken.removeBearer(jwtToken)));
    }

    @Nullable
    public String getHeaderParameterAsString(@Nonnull String headerName) {
        return this.tokenHeader.getAsString(headerName);
    }

    public boolean hasClaim(@Nonnull String claimName) {
        return this.tokenBody.contains(claimName);
    }

    public boolean hasHeaderParameter(@Nonnull String parameterName) {
        return this.tokenHeader.contains(parameterName);
    }

    @Nullable
    public String getClaimAsString(@Nonnull String claimName) {
        return this.tokenBody.getAsString(claimName);
    }

    @Nullable
    public List<String> getClaimAsStringList(@Nonnull String claimName) {
        return this.tokenBody.getAsStringList(claimName);
    }

    @Nullable
    public JsonObject getClaimAsJsonObject(@Nonnull String claimName) {
        return this.tokenBody.getJsonObject(claimName);
    }

    @Nullable
    public Instant getExpiration() {
        return this.tokenBody.getAsInstant("exp");
    }

    public boolean isExpired() {
        return this.getExpiration() == null || this.getExpiration().isBefore(LocalDateTime.now().toInstant(ZoneOffset.UTC));
    }

    @Nullable
    public Instant getNotBefore() {
        return this.tokenBody.contains("nbf") ? this.tokenBody.getAsInstant("nbf") : this.tokenBody.getAsInstant("iat");
    }

    public String getTokenValue() {
        return this.decodedJwt.getEncodedToken();
    }

    public boolean isXsuaaToken() {
        if (this.tokenBody.contains("ext_attr")) {
            JsonObject externalAttributes = this.tokenBody.getJsonObject("ext_attr");
            return "XSUAA".equalsIgnoreCase(externalAttributes.getAsString("enhancer"));
        }
        return false;
    }

    protected Principal createPrincipalByName(final String name) {
        return new Principal(){

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Principal)) {
                    return false;
                }
                Principal that = (Principal)o;
                return this.getName().equals(that.getName());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.getName());
            }

            @Override
            public String getName() {
                return name;
            }
        };
    }

    private static String removeBearer(@Nonnull String jwtToken) {
        Assertions.assertHasText((String)jwtToken, (String)"jwtToken must not be null / empty");
        Pattern bearerPattern = Pattern.compile("[B|b]earer ");
        return bearerPattern.matcher(jwtToken).replaceFirst("");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Token)) {
            return false;
        }
        Token that = (Token)obj;
        return this.getTokenValue().equals(that.getTokenValue());
    }

    public int hashCode() {
        return Objects.hash(this.getTokenValue());
    }

    public String getZoneId() {
        return this.getClaimAsString("zone_uuid");
    }

    public String toString() {
        return this.decodedJwt.toString();
    }

    public Map<String, Object> getHeaders() {
        return new JSONObject(this.decodedJwt.getHeader()).toMap();
    }

    public Map<String, Object> getClaims() {
        return new JSONObject(this.decodedJwt.getPayload()).toMap();
    }
}

