/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation;

import com.sap.cloud.security.token.validation.ValidationResult;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class ValidationResults {
    private static final Logger logger = LoggerFactory.getLogger(ValidationResults.class);
    private static final ValidationResult VALID_RESULT = new ValidationResultImpl();

    private ValidationResults() {
    }

    public static ValidationResult createInvalid(String errorDescription) {
        logger.warn(errorDescription);
        return new ValidationResultImpl(errorDescription);
    }

    public static ValidationResult createInvalid(String errorDescriptionTemplate, Object ... arguments) {
        String format = MessageFormatter.arrayFormat((String)errorDescriptionTemplate, (Object[])arguments).getMessage();
        return ValidationResults.createInvalid(format);
    }

    public static ValidationResult createValid() {
        return VALID_RESULT;
    }

    static class ValidationResultImpl
    implements ValidationResult {
        private final String validationError;

        public ValidationResultImpl(String validationError) {
            this.validationError = validationError;
        }

        public ValidationResultImpl() {
            this(null);
        }

        @Override
        @Nullable
        public String getErrorDescription() {
            return this.validationError;
        }

        public String toString() {
            return this.isValid() ? "Validation was successful." : this.getErrorDescription();
        }
    }
}

