/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.token.validation.validators;

import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.json.JsonObject;
import com.sap.cloud.security.token.SecurityContext;
import com.sap.cloud.security.token.Token;
import com.sap.cloud.security.token.validation.ValidationResult;
import com.sap.cloud.security.token.validation.ValidationResults;
import com.sap.cloud.security.token.validation.Validator;
import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.xsuaa.Assertions;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtX5tValidator
implements Validator<Token> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JwtX5tValidator.class);
    static final String VALIDATION_FAILED = "Certificate thumbprint validation failed";

    public JwtX5tValidator(OAuth2ServiceConfiguration config) {
        Assertions.assertNotNull((Object)config, (String)"Service configuration must not be null");
    }

    @Override
    public ValidationResult validate(Token token) {
        if (token == null) {
            return ValidationResults.createInvalid("No token passed to validate certificate thumbprint");
        }
        String tokenX5t = JwtX5tValidator.extractCnfThumbprintFromToken(token);
        LOGGER.debug("Token 'cnf' thumbprint: {}", (Object)tokenX5t);
        if (tokenX5t == null) {
            return ValidationResults.createInvalid("Token doesn't contain certificate thumbprint confirmation method");
        }
        Certificate clientCertificate = SecurityContext.getClientCertificate();
        if (clientCertificate == null) {
            return ValidationResults.createInvalid("Client certificate missing from SecurityContext");
        }
        String clientCertificateX5t = clientCertificate.getThumbprint();
        if (clientCertificateX5t.equals(tokenX5t)) {
            return ValidationResults.createValid();
        }
        return ValidationResults.createInvalid(VALIDATION_FAILED);
    }

    @Nullable
    private static String extractCnfThumbprintFromToken(Token token) {
        JsonObject cnf = token.getClaimAsJsonObject("cnf");
        return cnf == null ? null : cnf.getAsString("x5t#S256");
    }
}

