/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.security.x509;

import com.sap.cloud.security.x509.Certificate;
import com.sap.cloud.security.x509.InvalidCertificateException;
import com.sap.cloud.security.x509.X509Parser;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509Certificate
implements Certificate {
    private static final Logger LOGGER = LoggerFactory.getLogger(X509Certificate.class);
    private final java.security.cert.X509Certificate x509;
    private String thumbprint;

    private X509Certificate(java.security.cert.X509Certificate x509Certificate) {
        this.x509 = x509Certificate;
    }

    @Nullable
    public static X509Certificate newCertificate(String certificate) {
        if (certificate != null && !certificate.isEmpty()) {
            try {
                return new X509Certificate(X509Parser.parseCertificate((String)certificate));
            }
            catch (CertificateException e) {
                LOGGER.warn("Could not parse the certificate string", (Throwable)e);
            }
        }
        return null;
    }

    public String getThumbprint() throws InvalidCertificateException {
        if (this.thumbprint == null) {
            try {
                this.thumbprint = X509Parser.getCertificateThumbprint((java.security.cert.X509Certificate)this.x509);
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new InvalidCertificateException("Could not parse thumbprint", (Exception)e);
            }
        }
        return this.thumbprint;
    }
}

